/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.Plugin;
import hudson.model.Action;
import hudson.model.BallColor;
import hudson.model.Item;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.security.Permission;
import hudson.util.HttpResponses;
import io.jenkins.plugins.pipelinegraphview.Messages;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineGraph;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineGraphApi;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkins.ui.icon.IconSpec;
import org.jenkinsci.plugins.pipeline.modeldefinition.actions.RestartDeclarativePipelineAction;
import org.jenkinsci.plugins.workflow.cps.replay.ReplayAction;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.interceptor.RequirePOST;

public abstract class AbstractPipelineViewAction
implements Action,
IconSpec {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger LOGGER = Logger.getLogger(AbstractPipelineViewAction.class.getName());
    protected final transient PipelineGraphApi api;
    protected final transient WorkflowRun run;

    public AbstractPipelineViewAction(WorkflowRun target) {
        this.api = new PipelineGraphApi(target);
        this.run = target;
    }

    public boolean isBuildable() {
        return ((WorkflowJob)this.run.getParent()).isBuildable();
    }

    public boolean isBuildInProgress() {
        return this.run.isBuilding();
    }

    public Permission getPermission() {
        return Item.BUILD;
    }

    public Permission getCancelPermission() {
        return Item.CANCEL;
    }

    public Permission getConfigurePermission() {
        return Item.CONFIGURE;
    }

    public String getBuildDisplayName() {
        return this.run.getDisplayName();
    }

    public String getBuildFullDisplayName() {
        return this.run.getFullDisplayName();
    }

    public boolean isRebuildAvailable() {
        Plugin rebuildPlugin = Jenkins.get().getPlugin("rebuild");
        if (rebuildPlugin != null && rebuildPlugin.getWrapper().isEnabled()) {
            return ((WorkflowJob)this.run.getParent()).getProperty(ParametersDefinitionProperty.class) != null;
        }
        return false;
    }

    public boolean isRestartFromStageAvailable() {
        RestartDeclarativePipelineAction action = (RestartDeclarativePipelineAction)this.run.getAction(RestartDeclarativePipelineAction.class);
        if (action != null) {
            return action.isRestartEnabled();
        }
        return false;
    }

    @RequirePOST
    @JavaScriptMethod
    public boolean doRerun() throws IOException, ExecutionException {
        if (this.run != null) {
            this.run.checkAnyPermission(new Permission[]{Item.BUILD});
            ReplayAction replayAction = (ReplayAction)this.run.getAction(ReplayAction.class);
            Queue.Item item = replayAction.run2(replayAction.getOriginalScript(), replayAction.getOriginalLoadedScripts());
            return item != null;
        }
        return false;
    }

    @RequirePOST
    @JavaScriptMethod
    public HttpResponse doCancel() throws IOException, ExecutionException {
        if (this.run != null) {
            this.run.checkPermission(this.getCancelPermission());
            if (this.run.isBuilding()) {
                this.run.doStop();
                return HttpResponses.okJSON();
            }
            String message = Result.ABORTED.equals(this.run.getResult()) ? Messages.run_alreadyCancelled() : Messages.run_isFinished();
            return HttpResponses.errorJSON((String)message);
        }
        return HttpResponses.errorJSON((String)"No run to cancel");
    }

    public String getFullBuildDisplayName() {
        return this.run.getFullDisplayName();
    }

    public String getFullProjectDisplayName() {
        return ((WorkflowJob)this.run.getParent()).getFullDisplayName();
    }

    private String getBuildNumber(WorkflowRun run) {
        if (run != null) {
            return String.valueOf(run.getNumber());
        }
        return null;
    }

    public String getBuildUrl() {
        return this.run.getUrl();
    }

    public String getPreviousBuildNumber() {
        return this.getBuildNumber(this.run.getPreviousBuild());
    }

    public String getPreviousBuildUrl() {
        WorkflowRun previousBuild = this.run.getPreviousBuild();
        return previousBuild == null ? null : previousBuild.getUrl();
    }

    public String getNextBuildNumber() {
        return this.getBuildNumber(this.run.getNextBuild());
    }

    public BallColor getIconColor() {
        return this.run.getIconColor();
    }

    public String getBuildStatusIconClassName() {
        return this.run.getBuildStatusIconClassName();
    }

    protected JSONObject createJson(PipelineGraph pipelineGraph) throws JsonProcessingException {
        String graph = OBJECT_MAPPER.writeValueAsString((Object)pipelineGraph);
        return JSONObject.fromObject((Object)graph);
    }

    @WebMethod(name={"tree"})
    public HttpResponse getTree() throws JsonProcessingException {
        JSONObject graph = this.createJson(this.api.createTree());
        return HttpResponses.okJSON((JSONObject)graph);
    }

    @WebMethod(name={"replay"})
    public HttpResponse replayRun(StaplerRequest2 req) {
        Integer estimatedNextBuildNumber;
        JSONObject result = new JSONObject();
        try {
            estimatedNextBuildNumber = this.api.replay();
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOGGER.log(Level.SEVERE, "Failed to queue item", e);
            return HttpResponses.errorJSON((String)("failed to queue item: " + e.getMessage()));
        }
        if (estimatedNextBuildNumber == null) {
            return HttpResponses.errorJSON((String)"failed to get next build number");
        }
        result.put("url", (Object)(AbstractPipelineViewAction.appendTrailingSlashIfRequired(req.getContextPath()) + this.run.getUrl().replace("/" + this.run.getNumber() + "/", "/" + estimatedNextBuildNumber + "/") + "pipeline-overview"));
        result.put("success", (Object)true);
        return HttpResponses.okJSON((JSONObject)result);
    }

    private static String appendTrailingSlashIfRequired(String string) {
        if (string.endsWith("/")) {
            return string;
        }
        return string + "/";
    }

    public String getIconFileName() {
        return null;
    }

    public String getIconClassName() {
        return null;
    }
}

