/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.treescanner;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.pipelinegraphview.analysis.TimingInfo;
import io.jenkins.plugins.pipelinegraphview.treescanner.NodeRelationship;
import io.jenkins.plugins.pipelinegraphview.treescanner.NodeRelationshipFinder;
import io.jenkins.plugins.pipelinegraphview.treescanner.ParallelBlockRelationship;
import io.jenkins.plugins.pipelinegraphview.utils.FlowNodeWrapper;
import io.jenkins.plugins.pipelinegraphview.utils.NodeRunStatus;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineNodeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.pipeline.modeldefinition.actions.ExecutionModelAction;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineNodeTreeScanner {
    private final WorkflowRun run;
    private final FlowExecution execution;
    private List<FlowNode> heads;
    private Map<String, FlowNodeWrapper> stageNodeMap = new LinkedHashMap<String, FlowNodeWrapper>();
    private Map<String, FlowNodeWrapper> stepNodeMap = new LinkedHashMap<String, FlowNodeWrapper>();
    private final boolean declarative;
    private static final Logger logger = LoggerFactory.getLogger(PipelineNodeTreeScanner.class);
    private boolean isDebugEnabled = logger.isDebugEnabled();

    public PipelineNodeTreeScanner(@NonNull WorkflowRun run) {
        this.run = run;
        this.execution = run.getExecution();
        this.declarative = run.getAction(ExecutionModelAction.class) != null;
        this.build();
    }

    public void build() {
        if (this.isDebugEnabled) {
            logger.debug("Building graph");
        }
        if (this.execution != null) {
            LinkedHashMap<String, FlowNode> nodes = this.getAllNodes();
            NodeRelationshipFinder finder = new NodeRelationshipFinder();
            LinkedHashMap<String, NodeRelationship> relationships = finder.getNodeRelationships(nodes);
            GraphBuilder builder = new GraphBuilder(nodes, relationships, this.run, this.execution);
            if (this.isDebugEnabled) {
                logger.debug("Original nodes:");
                logger.debug("{}", builder.getNodes());
            }
            this.stageNodeMap = builder.getStageMapping();
            this.stepNodeMap = builder.getStepMapping();
            ArrayList<FlowNodeWrapper> remappedNodes = new ArrayList<FlowNodeWrapper>(this.stageNodeMap.values());
            remappedNodes.addAll(this.stepNodeMap.values());
            if (this.isDebugEnabled) {
                logger.debug("Remapped nodes:");
                logger.debug("{}", remappedNodes);
            }
        } else {
            this.stageNodeMap = new LinkedHashMap<String, FlowNodeWrapper>();
            this.stepNodeMap = new LinkedHashMap<String, FlowNodeWrapper>();
        }
        if (this.isDebugEnabled) {
            logger.debug("Graph built");
        }
    }

    private LinkedHashMap<String, FlowNode> getAllNodes() {
        this.heads = this.execution.getCurrentHeads();
        DepthFirstScanner scanner = new DepthFirstScanner();
        scanner.setup(this.heads);
        LinkedHashMap<String, FlowNode> nodeMap = new LinkedHashMap<String, FlowNode>();
        for (FlowNode n : scanner) {
            nodeMap.put(n.getId(), n);
        }
        return nodeMap;
    }

    @NonNull
    public List<FlowNodeWrapper> getStageSteps(String startNodeId) {
        ArrayList<FlowNodeWrapper> stageSteps = new ArrayList<FlowNodeWrapper>();
        FlowNodeWrapper wrappedStage = this.stageNodeMap.get(startNodeId);
        for (FlowNodeWrapper wrappedStep : this.stepNodeMap.values()) {
            if (!wrappedStep.getParents().contains(wrappedStage)) continue;
            stageSteps.add(wrappedStep);
        }
        Collections.sort(stageSteps, new FlowNodeWrapper.NodeComparator());
        if (this.isDebugEnabled) {
            logger.debug("Returning {} steps for node '{}'", (Object)stageSteps.size(), (Object)startNodeId);
        }
        return stageSteps;
    }

    @NonNull
    public Map<String, List<FlowNodeWrapper>> getAllSteps() {
        LinkedHashMap<String, List<FlowNodeWrapper>> stageNodeStepMap = new LinkedHashMap<String, List<FlowNodeWrapper>>();
        for (String stageId : this.stageNodeMap.keySet()) {
            stageNodeStepMap.put(stageId, this.getStageSteps(stageId));
        }
        return stageNodeStepMap;
    }

    @NonNull
    public List<FlowNodeWrapper> getPipelineNodes() {
        ArrayList<FlowNodeWrapper> stageNodes = new ArrayList<FlowNodeWrapper>(this.stageNodeMap.values());
        Collections.sort(stageNodes, new FlowNodeWrapper.NodeComparator());
        return stageNodes;
    }

    @NonNull
    public Map<String, FlowNodeWrapper> getPipelineNodeMap() {
        return this.stageNodeMap;
    }

    @NonNull
    public boolean isDeclarative() {
        return this.declarative;
    }

    private static class GraphBuilder {
        private final Map<String, FlowNode> nodeMap;
        private final Map<String, NodeRelationship> relationships;
        private final WorkflowRun run;
        @NonNull
        private final FlowExecution execution;
        private Map<String, FlowNodeWrapper> wrappedNodeMap = new LinkedHashMap<String, FlowNodeWrapper>();
        private Map<String, FlowNodeWrapper> wrappedStepMap;
        private Map<String, FlowNodeWrapper> wrappedStageMap;
        private final Logger logger = LoggerFactory.getLogger(GraphBuilder.class);
        private boolean isDebugEnabled = this.logger.isDebugEnabled();

        public GraphBuilder(@NonNull Map<String, FlowNode> nodeMap, @NonNull Map<String, NodeRelationship> relationships, @NonNull WorkflowRun run, @NonNull FlowExecution execution) {
            this.nodeMap = nodeMap;
            this.relationships = relationships;
            this.run = run;
            this.execution = execution;
            this.buildGraph();
        }

        protected List<FlowNodeWrapper> getNodes() {
            return this.wrappedNodeMap.entrySet().stream().map(entrySet -> (FlowNodeWrapper)entrySet.getValue()).collect(Collectors.toList());
        }

        @NonNull
        public Map<String, FlowNodeWrapper> getStageMapping() {
            Map<String, FlowNodeWrapper> stageMap;
            if (this.wrappedStageMap != null) {
                return this.wrappedStageMap;
            }
            if (this.isDebugEnabled) {
                this.logger.debug("Remapping stages");
            }
            if ((stageMap = this.wrappedNodeMap.entrySet().stream().filter(e -> this.shouldBeInStageMap((FlowNodeWrapper)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).isEmpty()) {
                stageMap = this.wrappedNodeMap.entrySet().stream().filter(e -> this.isStartNode((FlowNodeWrapper)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
            ArrayList<FlowNodeWrapper> nodeList = new ArrayList<FlowNodeWrapper>(stageMap.values());
            nodeList.sort(new FlowNodeWrapper.NodeComparator());
            for (FlowNodeWrapper stage : nodeList) {
                FlowNodeWrapper firstParent = stage.getFirstParent();
                if (this.isDebugEnabled) {
                    this.logger.debug("Stages has {} parents", (Object)stage.getParents().size());
                    this.logger.debug("First parent of stage {}: {}", (Object)stage.getId(), (Object)firstParent);
                    if (firstParent != null) {
                        this.logger.debug("Parent exists in stage map: {}", (Object)stageMap.containsKey(firstParent.getId()));
                    }
                }
                if (firstParent == null || stageMap.containsKey(firstParent.getId())) continue;
                stageMap.put(stage.getId(), this.remapNode(stage, stageMap));
            }
            this.wrappedStageMap = stageMap;
            return this.wrappedStageMap;
        }

        private boolean shouldBeInStageMap(FlowNodeWrapper n) {
            return !this.shouldBeInStepMap(n) && !this.isStartNode(n) && !n.isStepsBlock();
        }

        private boolean isStartNode(FlowNodeWrapper n) {
            return n.getType() == FlowNodeWrapper.NodeType.PIPELINE_START;
        }

        @NonNull
        private FlowNodeWrapper remapNode(@NonNull FlowNodeWrapper wrappedNode, @NonNull Map<String, FlowNodeWrapper> stageMap) {
            if (this.isDebugEnabled) {
                this.logger.debug("Remapping node {}, {}", (Object)wrappedNode.getId(), wrappedNode.getClass());
            }
            FlowNodeWrapper remappedNode = new FlowNodeWrapper(wrappedNode.getNode(), wrappedNode.getStatus(), wrappedNode.getTiming(), wrappedNode.getInputStep(), wrappedNode.getRun(), wrappedNode.getType());
            FlowNodeWrapper closestParent = this.findParentNode(wrappedNode, stageMap);
            if (this.isDebugEnabled) {
                this.logger.debug("Found closest parent for node {}, {}", (Object)wrappedNode.getId(), (Object)(closestParent != null ? closestParent.getId() : "null"));
            }
            if (closestParent != null) {
                remappedNode.addParent(closestParent);
                remappedNode.addEdge(closestParent);
            }
            return remappedNode;
        }

        @NonNull
        public Map<String, FlowNodeWrapper> getStepMapping() {
            if (this.wrappedStepMap != null) {
                return this.wrappedStepMap;
            }
            if (this.isDebugEnabled) {
                this.logger.debug("Remapping steps");
            }
            Map<String, FlowNodeWrapper> stepMap = this.wrappedNodeMap.entrySet().stream().filter(e -> this.shouldBeInStepMap((FlowNodeWrapper)e.getValue())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (FlowNodeWrapper)e.getValue()));
            Map<String, FlowNodeWrapper> stageMap = this.getStageMapping();
            ArrayList<FlowNodeWrapper> nodeList = new ArrayList<FlowNodeWrapper>(stepMap.values());
            Collections.sort(nodeList, new FlowNodeWrapper.NodeComparator());
            for (FlowNodeWrapper step : nodeList) {
                FlowNodeWrapper firstParent = step.getFirstParent();
                if (firstParent == null || stageMap.containsKey(firstParent.getId())) continue;
                stepMap.put(step.getId(), this.remapNode(step, stageMap));
            }
            this.wrappedStepMap = stepMap;
            return this.wrappedStepMap;
        }

        private boolean shouldBeInStepMap(FlowNodeWrapper n) {
            return n.isStep() || this.isExceptionStep(n);
        }

        private boolean isExceptionStep(FlowNodeWrapper n) {
            return n.getType() == FlowNodeWrapper.NodeType.UNHANDLED_EXCEPTION && n.isUnhandledException();
        }

        private void buildGraph() {
            ArrayList<FlowNode> nodeList = new ArrayList<FlowNode>(this.nodeMap.values());
            Collections.sort(nodeList, new FlowNodeWrapper.FlowNodeComparator());
            BlockEndNode<?> nodeThatThrewException = null;
            if (!nodeList.isEmpty()) {
                nodeThatThrewException = this.getUnhandledException((FlowNode)nodeList.get(nodeList.size() - 1));
            }
            for (FlowNode node : nodeList) {
                if (nodeThatThrewException == node) {
                    this.handleException(node, this.relationships.get(node.getId()));
                    continue;
                }
                if (node instanceof BlockEndNode) {
                    if (!this.isDebugEnabled) continue;
                    this.logger.debug("Skipping end node {}, {}", (Object)node.getId(), node.getClass());
                    continue;
                }
                if (this.isDebugEnabled) {
                    this.logger.debug("Wrapping {} [{}]", (Object)node.getId(), node.getClass());
                }
                FlowNodeWrapper wrappedNode = this.wrapNode(node, this.relationships.get(node.getId()));
                FlowNodeWrapper parent = this.findParentNode(wrappedNode, this.wrappedNodeMap);
                this.assignParent(wrappedNode, parent);
                this.wrappedNodeMap.put(node.getId(), wrappedNode);
            }
        }

        @CheckForNull
        private BlockEndNode<?> getUnhandledException(@NonNull FlowNode node) {
            ErrorAction errorAction = (ErrorAction)node.getAction(ErrorAction.class);
            if (errorAction != null && !PipelineNodeUtil.isJenkinsFailureException(errorAction.getError())) {
                FlowNode nodeThatThrewException;
                if (this.isDebugEnabled) {
                    this.logger.debug("getUnhandledException => Found unhandled exception: {}", (Object)errorAction.getError().getMessage());
                }
                if ((nodeThatThrewException = ErrorAction.findOrigin((Throwable)errorAction.getError(), (FlowExecution)this.execution)) instanceof BlockEndNode) {
                    if (this.isDebugEnabled) {
                        this.logger.debug("getUnhandledException => Returning nodeThatThrewException: {}", (Object)nodeThatThrewException.getId());
                    }
                    return (BlockEndNode)nodeThatThrewException;
                }
                if (node instanceof BlockEndNode && this.nodeMap.values().size() <= 2) {
                    if (this.isDebugEnabled) {
                        this.logger.debug("getUnhandledException => Returning node: {}", (Object)node.getId());
                    }
                    return (BlockEndNode)node;
                }
                this.logger.error("Could not find BlockEndNode that threw exception:{}.", (Object)errorAction.getDisplayName());
            }
            return null;
        }

        private void handleException(@NonNull FlowNode nodeWhichThrewException, @NonNull NodeRelationship relationship) {
            assert (relationship != null);
            if (this.isDebugEnabled) {
                this.logger.debug("Wrapping nodeWhichThrewException {} [{}]", (Object)nodeWhichThrewException.getId(), nodeWhichThrewException.getClass());
            }
            FlowNodeWrapper wrappedNode = this.wrapNode(nodeWhichThrewException, relationship);
            BlockStartNode startNode = null;
            startNode = ((BlockEndNode)nodeWhichThrewException).getStartNode();
            this.assignParent(wrappedNode, (FlowNode)startNode);
            this.wrappedNodeMap.put(wrappedNode.getId(), wrappedNode);
        }

        private void assignParent(@NonNull FlowNodeWrapper wrappedNode, @CheckForNull FlowNode parent) {
            if (parent != null) {
                if (!this.wrappedNodeMap.containsKey(parent.getId())) {
                    this.logger.error("Couldn't find start of node {} (parent of {}) in wrappedNodeMap.", (Object)parent.getId(), (Object)wrappedNode.getId());
                } else {
                    FlowNodeWrapper wrappedParent = this.wrappedNodeMap.get(parent.getId());
                    this.assignParent(wrappedNode, wrappedParent);
                }
            }
        }

        private void assignParent(@NonNull FlowNodeWrapper wrappedNode, @CheckForNull FlowNodeWrapper wrappedParent) {
            if (wrappedParent != null) {
                if (this.isDebugEnabled) {
                    this.logger.debug("Adding parent {} to {}", (Object)wrappedParent.getId(), (Object)wrappedNode.getId());
                }
                wrappedNode.addParent(wrappedParent);
            }
        }

        @CheckForNull
        private FlowNodeWrapper findParentNode(@NonNull FlowNodeWrapper child, @NonNull Map<String, FlowNodeWrapper> wrappedNodeMap) {
            List enclosingIds = child.getNode().getAllEnclosingIds();
            Set<String> knownNodes = wrappedNodeMap.keySet();
            for (String possibleParentId : enclosingIds) {
                if (this.isDebugEnabled) {
                    this.logger.debug("Checking if {} in {}", (Object)possibleParentId, (Object)String.join((CharSequence)", ", knownNodes));
                }
                if (!knownNodes.contains(possibleParentId)) continue;
                return wrappedNodeMap.get(possibleParentId);
            }
            return null;
        }

        @NonNull
        private FlowNodeWrapper wrapNode(@NonNull FlowNode node, @NonNull NodeRelationship relationship) {
            TimingInfo timing = null;
            NodeRunStatus status = null;
            if (relationship instanceof ParallelBlockRelationship && PipelineNodeUtil.isParallelBranch(node)) {
                ParallelBlockRelationship parallelRelationship = (ParallelBlockRelationship)relationship;
                timing = parallelRelationship.getBranchTimingInfo(this.run, (BlockStartNode)node);
                status = parallelRelationship.getBranchStatus(this.run, (BlockStartNode)node);
            } else {
                timing = relationship.getTimingInfo(this.run);
                status = relationship.getStatus(this.run);
            }
            return new FlowNodeWrapper(node, status, timing, this.run);
        }
    }
}

