/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.utils;

import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Queue;
import io.jenkins.plugins.pipelinegraphview.treescanner.PipelineNodeGraphAdapter;
import io.jenkins.plugins.pipelinegraphview.utils.FlowNodeWrapper;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineGraph;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineGraphBuilderApi;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStage;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStageInternal;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineState;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.workflow.actions.WorkspaceAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineGraphApi {
    private static final Logger logger = LoggerFactory.getLogger(PipelineGraphApi.class);
    private final transient WorkflowRun run;

    public PipelineGraphApi(WorkflowRun run) {
        this.run = run;
    }

    public Integer replay() throws ExecutionException, InterruptedException, TimeoutException {
        this.run.checkPermission(Item.BUILD);
        CauseAction causeAction = new CauseAction((Cause)new Cause.UserIdCause());
        if (!((WorkflowJob)this.run.getParent()).isBuildable()) {
            return null;
        }
        Queue.Item item = Queue.getInstance().schedule2((Queue.Task)this.run.getParent(), 0, new Action[]{causeAction}).getItem();
        if (item == null) {
            return null;
        }
        return ((WorkflowJob)this.run.getParent()).getNextBuildNumber();
    }

    private List<PipelineStageInternal> getPipelineNodes(PipelineGraphBuilderApi builder) {
        return builder.getPipelineNodes().stream().map(flowNodeWrapper -> new PipelineStageInternal(flowNodeWrapper.getId(), flowNodeWrapper.getDisplayName(), flowNodeWrapper.getParents().stream().map(FlowNodeWrapper::getId).collect(Collectors.toList()), PipelineState.of(flowNodeWrapper.getStatus()), flowNodeWrapper.getType().name(), flowNodeWrapper.getDisplayName(), flowNodeWrapper.isSynthetic(), flowNodeWrapper.getTiming(), PipelineGraphApi.getStageNode(flowNodeWrapper))).collect(Collectors.toList());
    }

    private Function<String, PipelineStage> mapper(Map<String, PipelineStageInternal> stageMap, Map<String, List<String>> stageToChildrenMap) {
        String runUrl = this.run.getUrl();
        return id -> {
            List orDefault = stageToChildrenMap.getOrDefault(id, Collections.emptyList());
            List<PipelineStage> children = orDefault.stream().map(this.mapper(stageMap, stageToChildrenMap)).collect(Collectors.toList());
            return ((PipelineStageInternal)stageMap.get(id)).toPipelineStage(children, runUrl);
        };
    }

    private PipelineGraph createTree(PipelineGraphBuilderApi builder) {
        List<PipelineStageInternal> stages = this.getPipelineNodes(builder);
        Map stageMap = stages.stream().collect(Collectors.toMap(PipelineStageInternal::getId, stage -> stage, (u, v) -> u, LinkedHashMap::new));
        HashMap stageToChildrenMap = new HashMap();
        ArrayList childNodes = new ArrayList();
        FlowExecution execution = this.run.getExecution();
        if (execution == null) {
            return new PipelineGraph(new ArrayList<PipelineStage>(), false);
        }
        stages.forEach(stage -> {
            if (stage.getParents().isEmpty()) {
                stageToChildrenMap.put(stage.getId(), new ArrayList());
            } else {
                List parentChildren = stageToChildrenMap.getOrDefault(stage.getParents().get(0), new ArrayList());
                parentChildren.add(stage.getId());
                childNodes.add(stage.getId());
                stageToChildrenMap.put(stage.getParents().get(0), parentChildren);
            }
        });
        String runUrl = this.run.getUrl();
        List<PipelineStage> stageResults = stageMap.values().stream().map(pipelineStageInternal -> {
            List<PipelineStage> children = stageToChildrenMap.getOrDefault(pipelineStageInternal.getId(), Collections.emptyList()).stream().map(this.mapper(stageMap, stageToChildrenMap)).collect(Collectors.toList());
            return pipelineStageInternal.toPipelineStage(children, runUrl);
        }).filter(stage -> !childNodes.contains(stage.getId())).collect(Collectors.toList());
        return new PipelineGraph(stageResults, execution.isComplete());
    }

    private static String getStageNode(FlowNodeWrapper flowNodeWrapper) {
        FlowNode flowNode = flowNodeWrapper.getNode();
        DepthFirstScanner scan = new DepthFirstScanner();
        logger.debug("Checking node {}", (Object)flowNode);
        FlowExecution execution = flowNode.getExecution();
        for (FlowNode n : scan.allNodes(execution)) {
            boolean isWorkspaceNode;
            WorkspaceAction ws = (WorkspaceAction)n.getAction(WorkspaceAction.class);
            if (ws == null) continue;
            logger.debug("Found workspace node: {}", (Object)n);
            boolean bl = isWorkspaceNode = Objects.equals(n.getId(), flowNode.getId()) || Objects.equals(n.getEnclosingId(), flowNode.getId()) || flowNode.getAllEnclosingIds().contains(n.getId());
            if (flowNodeWrapper.getType() == FlowNodeWrapper.NodeType.PARALLEL) {
                try {
                    FlowNode p;
                    if (n.getEnclosingId() != null && (p = execution.getNode(n.getEnclosingId())) != null && p.getEnclosingId() != null && (p = execution.getNode(p.getEnclosingId())) != null && p.getEnclosingId() != null) {
                        isWorkspaceNode = Objects.equals(flowNode.getId(), p.getEnclosingId());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!isWorkspaceNode) continue;
            logger.debug("Found correct stage node: {}", (Object)n.getId());
            String node = ws.getNode();
            if (node.isEmpty()) {
                node = "built-in";
            }
            return node;
        }
        return null;
    }

    public PipelineGraph createTree() {
        return this.createTree(new PipelineNodeGraphAdapter(this.run));
    }
}

