/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.treescanner;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.pipelinegraphview.treescanner.NodeRelationship;
import io.jenkins.plugins.pipelinegraphview.utils.NodeRunStatus;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineNodeUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.GenericStatus;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.StatusAndTiming;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.TimingInfo;
import org.jenkinsci.plugins.workflow.support.actions.PauseAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelBlockRelationship
extends NodeRelationship {
    private static final Logger logger = LoggerFactory.getLogger(ParallelBlockRelationship.class);
    private boolean isDebugEnabled = logger.isDebugEnabled();
    @NonNull
    protected List<BlockStartNode> branchStarts = new ArrayList<BlockStartNode>();
    @NonNull
    protected List<FlowNode> branchEnds = new ArrayList<FlowNode>();
    protected Map<String, GenericStatus> branchStatuses;
    protected Map<String, TimingInfo> branchTimings;
    protected GenericStatus overallStatus;
    protected TimingInfo overallTiming;

    public ParallelBlockRelationship(@NonNull FlowNode start, @NonNull FlowNode end, @NonNull FlowNode after, List<BlockStartNode> branchStarts, List<FlowNode> branchEnds) {
        super(start, end, after);
        this.branchStarts = branchStarts;
        this.branchEnds = branchEnds;
    }

    public ParallelBlockRelationship(@NonNull FlowNode start, @NonNull FlowNode end, @CheckForNull FlowNode after, ArrayDeque<NodeRelationship> branchRelationships) {
        super(start, end, after);
        this.branchStarts = new ArrayList<BlockStartNode>();
        this.branchEnds = new ArrayList<FlowNode>();
        for (NodeRelationship r : branchRelationships) {
            this.branchStarts.add((BlockStartNode)r.getStart());
            this.branchEnds.add(r.getEnd());
        }
    }

    @NonNull
    public List<BlockStartNode> getBranchStarts() {
        return this.branchStarts;
    }

    @NonNull
    public List<FlowNode> getBranchEnds() {
        return this.branchEnds;
    }

    @Override
    @NonNull
    public TimingInfo getTimingInfo(WorkflowRun run) {
        if (this.overallTiming == null) {
            this.calculateTimings(run);
        }
        return this.overallTiming;
    }

    private String getBranchName(BlockStartNode start) {
        ThreadNameAction branchName = (ThreadNameAction)start.getAction(ThreadNameAction.class);
        assert (branchName != null);
        return branchName.getThreadName();
    }

    @NonNull
    public TimingInfo getBranchTimingInfo(WorkflowRun run, BlockStartNode startNode) {
        if (this.branchTimings == null) {
            this.calculateTimings(run);
        }
        return this.branchTimings.get(this.getBranchName(startNode));
    }

    private void calculateTimings(WorkflowRun run) {
        long[] pauseDurations = this.branchStarts.stream().mapToLong(s -> PauseAction.getPauseDuration((FlowNode)s)).toArray();
        FlowNode parallelEndNode = this.start != this.end ? this.end : null;
        for (int i = 0; i < this.branchStarts.size(); ++i) {
            FlowNode branchStart = (FlowNode)this.branchStarts.get(i);
            FlowNode branchEnd = this.branchEnds.get(i);
            if (!this.isDebugEnabled) continue;
            logger.debug("Calculating parallel branch timings {}, {}", (Object)branchStart.getId(), (Object)(branchEnd != null ? branchEnd.getId() : "null"));
        }
        this.branchTimings = StatusAndTiming.computeParallelBranchTimings((WorkflowRun)run, (FlowNode)this.start, this.branchStarts, this.branchEnds, (FlowNode)parallelEndNode, (long[])pauseDurations);
        if (this.isDebugEnabled) {
            logger.debug("Calculating parallel timings {}, {} (with above branches)", (Object)this.start.getId(), (Object)this.end.getId());
        }
        this.overallTiming = StatusAndTiming.computeOverallParallelTiming((WorkflowRun)run, this.branchTimings, (FlowNode)this.start, (FlowNode)parallelEndNode);
    }

    @Override
    @NonNull
    public NodeRunStatus getStatus(WorkflowRun run) {
        if (this.overallStatus == null) {
            this.calculateStatuses(run);
        }
        if (this.isDebugEnabled) {
            logger.debug("Overall status for '{}': '{}'", (Object)this.start, (Object)this.overallStatus);
        }
        return new NodeRunStatus(this.overallStatus);
    }

    @NonNull
    public NodeRunStatus getBranchStatus(WorkflowRun run, BlockStartNode branchStartNode) {
        if (this.branchStatuses == null) {
            this.calculateStatuses(run);
        }
        if (this.isDebugEnabled) {
            logger.debug("Branch status for {} ({}): '{}'", new Object[]{branchStartNode.getId(), this.getBranchName(branchStartNode), this.branchStatuses.get(this.getBranchName(branchStartNode))});
        }
        boolean skippedStage = PipelineNodeUtil.isSkippedStage((FlowNode)branchStartNode);
        return new NodeRunStatus(this.branchStatuses.get(this.getBranchName(branchStartNode)), skippedStage);
    }

    private void calculateStatuses(WorkflowRun run) {
        FlowNode parallelEndNode = this.start != this.end ? this.end : null;
        this.branchStatuses = StatusAndTiming.computeBranchStatuses2((WorkflowRun)run, (FlowNode)this.start, this.branchStarts, this.branchEnds, (FlowNode)parallelEndNode);
        for (int i = 0; i < this.branchStarts.size(); ++i) {
            BlockStartNode branchStart = this.branchStarts.get(i);
            FlowNode branchEnd = this.branchEnds.get(i);
            if (!this.isDebugEnabled) continue;
            logger.debug("Calculating parallel branch status {}, {}: {}", new Object[]{branchStart.getId(), branchEnd != null ? branchEnd.getId() : "null", this.getBranchStatus(run, branchStart)});
        }
        if (this.isDebugEnabled) {
            logger.debug("Calculating parallel status {}, {} (with above branches)", (Object)this.start.getId(), (Object)this.end.getId());
        }
        this.overallStatus = StatusAndTiming.condenseStatus(this.branchStatuses.values());
    }
}

