/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.treescanner;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Result;
import io.jenkins.plugins.pipelinegraphview.utils.BlueRun;
import io.jenkins.plugins.pipelinegraphview.utils.NodeRunStatus;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineNodeUtil;
import org.jenkinsci.plugins.workflow.actions.WarningAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.GenericStatus;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.StatusAndTiming;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.TimingInfo;
import org.jenkinsci.plugins.workflow.support.actions.PauseAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeRelationship {
    private boolean isDebugEnabled = logger.isDebugEnabled();
    private static final Logger logger = LoggerFactory.getLogger(NodeRelationship.class);
    @NonNull
    protected FlowNode start;
    @NonNull
    protected FlowNode end;
    @CheckForNull
    protected FlowNode before;
    @CheckForNull
    protected FlowNode after;

    public NodeRelationship(@NonNull FlowNode start, @NonNull FlowNode end, @CheckForNull FlowNode after) {
        assert (start != null);
        assert (end != null);
        this.after = after;
        this.start = start;
        this.end = end;
    }

    @CheckForNull
    public FlowNode getBefore() {
        return this.before;
    }

    public void setBefore(@CheckForNull FlowNode before) {
        this.before = before;
    }

    @CheckForNull
    public FlowNode getAfter() {
        return this.after;
    }

    @NonNull
    public FlowNode getStart() {
        return this.start;
    }

    @NonNull
    public FlowNode getEnd() {
        return this.end;
    }

    @NonNull
    public TimingInfo getTimingInfo(@NonNull WorkflowRun run) {
        TimingInfo timing;
        long pause = PauseAction.getPauseDuration((FlowNode)this.start);
        if (this.isDebugEnabled) {
            logger.debug("Calculating Chunk Timing info start: {}, end: {} after: {}", new Object[]{this.start.getId(), this.end.getId(), this.after != null ? this.after.getId() : "null"});
        }
        if ((timing = StatusAndTiming.computeChunkTiming((WorkflowRun)run, (long)pause, (FlowNode)this.start, (FlowNode)this.end, (FlowNode)this.after)) != null) {
            return timing;
        }
        return new TimingInfo(0L, 0L, 0L);
    }

    @NonNull
    public NodeRunStatus getStatus(WorkflowRun run) {
        WarningAction warningAction;
        boolean skippedStage = PipelineNodeUtil.isSkippedStage(this.start);
        if (skippedStage) {
            return new NodeRunStatus(BlueRun.BlueRunResult.NOT_BUILT, BlueRun.BlueRunState.SKIPPED);
        }
        if (PipelineNodeUtil.isPaused(this.end)) {
            return new NodeRunStatus(BlueRun.BlueRunResult.UNKNOWN, BlueRun.BlueRunState.PAUSED);
        }
        if (PipelineNodeUtil.isStage(this.start) && (warningAction = (WarningAction)this.start.getPersistentAction(WarningAction.class)) != null) {
            return new NodeRunStatus(GenericStatus.fromResult((Result)warningAction.getResult()));
        }
        if (this.isDebugEnabled) {
            logger.debug("Calculating Chunk Status start: {}, end: {} after: {}", new Object[]{this.start.getId(), this.end.getId(), this.after != null ? this.after.getId() : "null"});
        }
        if (this.start.getId().equals(this.end.getId())) {
            return new NodeRunStatus(this.start);
        }
        return new NodeRunStatus(StatusAndTiming.computeChunkStatus2((WorkflowRun)run, (FlowNode)this.before, (FlowNode)this.start, (FlowNode)this.end, (FlowNode)this.after));
    }
}

