/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.consoleview;

import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.console.AnnotatedLargeText;
import hudson.util.HttpResponses;
import io.jenkins.plugins.pipelinegraphview.PipelineGraphViewConfiguration;
import io.jenkins.plugins.pipelinegraphview.cards.RunDetailsCard;
import io.jenkins.plugins.pipelinegraphview.cards.RunDetailsItem;
import io.jenkins.plugins.pipelinegraphview.cards.items.ArtifactRunDetailsItem;
import io.jenkins.plugins.pipelinegraphview.cards.items.SCMRunDetailsItems;
import io.jenkins.plugins.pipelinegraphview.cards.items.TestResultRunDetailsItem;
import io.jenkins.plugins.pipelinegraphview.cards.items.TimingRunDetailsItems;
import io.jenkins.plugins.pipelinegraphview.cards.items.UpstreamCauseRunDetailsItem;
import io.jenkins.plugins.pipelinegraphview.cards.items.UserIdCauseRunDetailsItem;
import io.jenkins.plugins.pipelinegraphview.utils.AbstractPipelineViewAction;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineNodeUtil;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStep;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStepApi;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStepList;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.verb.GET;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineConsoleViewAction
extends AbstractPipelineViewAction {
    public static final long LOG_THRESHOLD = 153600L;
    public static final String URL_NAME = "pipeline-console";
    private static final Logger logger = LoggerFactory.getLogger(PipelineConsoleViewAction.class);
    private final WorkflowRun target;
    private final PipelineStepApi stepApi;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public PipelineConsoleViewAction(WorkflowRun target) {
        super(target);
        this.target = target;
        this.stepApi = new PipelineStepApi(target);
    }

    public String getDisplayName() {
        return "Pipeline Console";
    }

    public String getUrlName() {
        return URL_NAME;
    }

    @Override
    public String getIconClassName() {
        return "symbol-terminal-outline plugin-ionicons-api";
    }

    public String getDurationString() {
        return this.run.getDurationString();
    }

    public String getStartTimeString() {
        return this.run.getTimestampString();
    }

    public String getUrl() {
        return this.target.getUrl();
    }

    @GET
    @WebMethod(name={"steps"})
    public HttpResponse getSteps(StaplerRequest2 req) throws IOException {
        String nodeId = req.getParameter("nodeId");
        if (nodeId != null) {
            return HttpResponses.okJSON((JSONObject)this.getSteps(nodeId));
        }
        return HttpResponses.errorJSON((String)"Error getting console text");
    }

    private JSONObject getSteps(String nodeId) throws IOException {
        logger.debug("getSteps was passed nodeId '{}'.", (Object)nodeId);
        PipelineStepList steps = this.stepApi.getSteps(nodeId);
        String stepsJson = MAPPER.writeValueAsString((Object)steps);
        if (logger.isDebugEnabled()) {
            logger.debug("Steps for {}: '{}'.", (Object)nodeId, (Object)stepsJson);
        }
        return JSONObject.fromObject((Object)stepsJson);
    }

    @GET
    @WebMethod(name={"allSteps"})
    public HttpResponse getAllSteps(StaplerRequest2 req) throws IOException {
        return HttpResponses.okJSON((JSONObject)this.getAllSteps());
    }

    protected JSONObject getAllSteps() throws IOException {
        PipelineStepList steps = this.stepApi.getAllSteps();
        String stepsJson = MAPPER.writeValueAsString((Object)steps);
        if (logger.isDebugEnabled()) {
            logger.debug("Steps: '{}'.", (Object)stepsJson);
        }
        return JSONObject.fromObject((Object)stepsJson);
    }

    @WebMethod(name={"log"})
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="Doesn't seem to matter in practice, docs aren't clear on how to handle and most places ignore it")
    public void getConsoleText(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        String nodeId = req.getParameter("nodeId");
        if (nodeId == null) {
            logger.error("'consoleText' was not passed 'nodeId'.");
            rsp.getWriter().write("Error getting console text\n");
            return;
        }
        logger.debug("getConsoleText was passed node id '{}'.", (Object)nodeId);
        AnnotatedLargeText<? extends FlowNode> logText = this.getLogForNode(nodeId);
        if (logText != null) {
            logText.writeLogTo(0L, (OutputStream)rsp.getOutputStream());
            return;
        }
        boolean foundLogs = false;
        PipelineStepList steps = this.stepApi.getSteps(nodeId);
        for (PipelineStep step : steps.getSteps()) {
            logText = this.getLogForNode(step.getId());
            if (logText == null) continue;
            foundLogs = true;
            logText.writeLogTo(0L, (OutputStream)rsp.getOutputStream());
        }
        if (!foundLogs) {
            rsp.getWriter().write("No logs found\n");
        }
    }

    @GET
    @WebMethod(name={"consoleOutput"})
    public HttpResponse getConsoleOutput(StaplerRequest2 req) throws IOException {
        String nodeId = req.getParameter("nodeId");
        if (nodeId == null) {
            logger.error("'consoleJson' was not passed 'nodeId'.");
            return HttpResponses.errorJSON((String)"Error getting console json");
        }
        logger.debug("getConsoleOutput was passed node id '{}'.", (Object)nodeId);
        Long startByte = PipelineConsoleViewAction.parseIntWithDefault(req.getParameter("startByte"), -153600L);
        JSONObject data = this.getConsoleOutputJson(nodeId, startByte);
        if (data == null) {
            return HttpResponses.errorJSON((String)"Something went wrong - check Jenkins logs.");
        }
        return HttpResponses.okJSON((JSONObject)data);
    }

    protected JSONObject getConsoleOutputJson(String nodeId, Long requestStartByte) throws IOException {
        Long startByte = 0L;
        long endByte = 0L;
        Object text = "";
        AnnotatedLargeText<? extends FlowNode> logText = this.getLogForNode(nodeId);
        if (logText != null) {
            long textLength = logText.length();
            if (requestStartByte > textLength) {
                logger.error("consoleJson - user requested startByte larger than console output.");
                return null;
            }
            if (requestStartByte < 0L) {
                logger.debug("consoleJson - requested negative startByte '{}'.", (Object)requestStartByte);
                startByte = textLength + requestStartByte;
                if (startByte < 0L) {
                    logger.debug("consoleJson - requested negative startByte '{}' out of bounds, starting at 0.", (Object)requestStartByte);
                    startByte = 0L;
                }
            } else {
                startByte = requestStartByte;
            }
            logger.debug("Returning '{}' bytes from 'getConsoleOutput'.", (Object)(textLength - startByte));
            text = PipelineNodeUtil.convertLogToString(logText, startByte);
            endByte = textLength;
        }
        if (this.isUnhandledException(nodeId)) {
            String nodeExceptionText = this.getNodeExceptionText(nodeId);
            if (nodeExceptionText != null) {
                text = (String)text + nodeExceptionText;
            }
            endByte += (long)((String)text).length();
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("text", text);
        response.put("startByte", startByte);
        response.put("endByte", endByte);
        return JSONObject.fromObject(response);
    }

    private AnnotatedLargeText<? extends FlowNode> getLogForNode(String nodeId) throws IOException {
        FlowExecution execution = this.target.getExecution();
        if (execution != null) {
            logger.debug("getLogForNode found execution.");
            return PipelineNodeUtil.getLogText(execution.getNode(nodeId));
        }
        return null;
    }

    private String getNodeExceptionText(String nodeId) throws IOException {
        FlowExecution execution = this.target.getExecution();
        if (execution != null) {
            logger.debug("getNodeException found execution.");
            return PipelineNodeUtil.getExceptionText(execution.getNode(nodeId));
        }
        return null;
    }

    private boolean isUnhandledException(String nodeId) throws IOException {
        FlowExecution execution = this.target.getExecution();
        if (execution != null) {
            return PipelineNodeUtil.isUnhandledException(execution.getNode(nodeId));
        }
        return false;
    }

    private static long parseIntWithDefault(String s, long defaultValue) {
        try {
            logger.debug("Parsing user provided value of '{}'", (Object)s);
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            logger.debug("Using default value of '{}'", (Object)defaultValue);
            return defaultValue;
        }
    }

    public RunDetailsCard getRunDetailsCard() {
        ArrayList<RunDetailsItem> runDetailsItems = new ArrayList<RunDetailsItem>(SCMRunDetailsItems.get(this.run));
        if (!runDetailsItems.isEmpty()) {
            runDetailsItems.add(new RunDetailsItem.Builder().separator().build());
        }
        UpstreamCauseRunDetailsItem.get(this.run).ifPresent(runDetailsItems::add);
        UserIdCauseRunDetailsItem.get(this.run).ifPresent(runDetailsItems::add);
        runDetailsItems.addAll(TimingRunDetailsItems.get(this.run));
        TestResultRunDetailsItem.get(this.run).ifPresent(runDetailsItems::add);
        ArtifactRunDetailsItem.get(this.run).ifPresent(runDetailsItems::add);
        return new RunDetailsCard(runDetailsItems);
    }

    public boolean isShowGraphOnBuildPage() {
        return PipelineGraphViewConfiguration.get().isShowGraphOnBuildPage();
    }
}

