/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.workfloworas;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.security.ACL;
import hudson.slaves.WorkspaceList;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jenkins.model.Jenkins;
import land.oras.ArtifactType;
import land.oras.ContainerRef;
import land.oras.Layer;
import land.oras.Manifest;
import land.oras.Registry;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsFlowFactoryAction2;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinitionDescriptor;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import org.springframework.security.core.Authentication;

public class CpsOrasFlowDefinition
extends FlowDefinition {
    public static final ArtifactType ARTIFACT_TYPE_SCRIPT = ArtifactType.from((String)"application/vnd.jenkins.pipeline.manifest.v1+json");
    public static final ArtifactType ARTIFACT_TYPE_REPO = ArtifactType.from((String)"application/vnd.jenkins.repo.manifest.v1+json");
    private String credentialsId;
    private final String containerRef;
    private String scriptPath;

    @DataBoundConstructor
    public CpsOrasFlowDefinition(String containerRef) {
        this.containerRef = containerRef;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getContainerRef() {
        return this.containerRef;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    @DataBoundSetter
    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public FlowExecution create(FlowExecutionOwner owner, TaskListener listener, List<? extends Action> actions) throws Exception {
        for (Action action : actions) {
            if (!(action instanceof CpsFlowFactoryAction2)) continue;
            return ((CpsFlowFactoryAction2)action).create((FlowDefinition)this, owner, actions);
        }
        Queue.Executable executable = owner.getExecutable();
        if (!(executable instanceof Run)) {
            throw new IOException("Can only pull a Jenkinsfile in a run");
        }
        Run run = (Run)executable;
        Registry registry = CpsOrasFlowDefinition.buildRegistry((Item)run.getParent(), this.credentialsId);
        StandardUsernamePasswordCredentials credentials = CpsOrasFlowDefinition.getCredentials((Item)run.getParent(), this.credentialsId);
        if (credentials != null) {
            CredentialsProvider.track((Run)run, (Credentials)credentials);
        }
        ContainerRef containerRef = ContainerRef.parse((String)this.containerRef);
        Manifest manifest = registry.getManifest(containerRef);
        CpsOrasFlowDefinition.ensureArtifactType(this.scriptPath, manifest);
        String digest = ((Layer)manifest.getLayers().get(0)).getDigest();
        if (digest == null || digest.isEmpty()) {
            throw new IllegalArgumentException("No digest found for the container reference: " + String.valueOf(containerRef));
        }
        if (!CpsOrasFlowDefinition.hasScriptPath(this.scriptPath)) {
            listener.getLogger().printf("Using pipeline script from container %s with digest %s%n", this.containerRef, digest);
            try (InputStream is = registry.fetchBlob(containerRef.withDigest(digest));){
                CpsFlowExecution cpsFlowExecution = new CpsFlowExecution(new String(is.readAllBytes(), StandardCharsets.UTF_8), true, owner);
                return cpsFlowExecution;
            }
        }
        FilePath dir = this.getDownloadFolder(owner);
        Computer computer = Jenkins.get().toComputer();
        if (computer == null) {
            throw new IOException(Jenkins.get().getDisplayName() + " may be offline");
        }
        listener.getLogger().printf("Using pipeline script %s from container %s with digest %s%n", this.scriptPath, this.containerRef, digest);
        try (WorkspaceList.Lease lease = computer.getWorkspaceList().allocate(dir);){
            Path scriptPathFile = Path.of(this.scriptPath, new String[0]).normalize();
            Path remote = Path.of(lease.path.getRemote(), new String[0]);
            Path resolved = remote.resolve(scriptPathFile).normalize();
            if (!resolved.startsWith(remote)) {
                throw new SecurityException("Only script path inside archive can be selected: " + String.valueOf(scriptPathFile));
            }
            registry.pullArtifact(containerRef, remote, true);
            if (!Files.exists(resolved, new LinkOption[0])) {
                throw new IOException("Script path does not exist in the container: " + String.valueOf(scriptPathFile));
            }
            String content = Files.readString(resolved);
            Util.deleteRecursive((File)remote.toFile());
            CpsFlowExecution cpsFlowExecution = new CpsFlowExecution(content, true, owner);
            return cpsFlowExecution;
        }
    }

    private static boolean hasScriptPath(String scriptPath) {
        return scriptPath != null && !scriptPath.isEmpty();
    }

    private FilePath getDownloadFolder(FlowExecutionOwner owner) throws IOException {
        FilePath baseWorkspace;
        if (owner.getExecutable().getParent() instanceof TopLevelItem) {
            baseWorkspace = Jenkins.get().getWorkspaceFor((TopLevelItem)owner.getExecutable().getParent());
            if (baseWorkspace == null) {
                throw new IOException(Jenkins.get().getDisplayName() + " may be offline");
            }
        } else {
            throw new AbortException("Cannot check out in non-top-level build");
        }
        FilePath dir = baseWorkspace.withSuffix(CpsOrasFlowDefinition.getFilePathSuffix() + "cps");
        return dir;
    }

    private static String getFilePathSuffix() {
        return System.getProperty(WorkspaceList.class.getName(), "@");
    }

    private static Registry buildRegistry(Item item, String credentialsId) {
        Registry.Builder builder = Registry.builder();
        if (credentialsId == null || credentialsId.isEmpty()) {
            return builder.insecure().build();
        }
        StandardUsernamePasswordCredentials credentials = CpsOrasFlowDefinition.getCredentials(item, credentialsId);
        if (credentials == null) {
            throw new IllegalArgumentException("No credentials found with ID: " + credentialsId);
        }
        return builder.defaults(credentials.getUsername(), credentials.getPassword().getPlainText()).build();
    }

    @Nullable
    public static StandardUsernamePasswordCredentials getCredentials(Item item, String credentialsId) {
        if (credentialsId == null || credentialsId.isEmpty()) {
            return null;
        }
        return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItem(StandardUsernamePasswordCredentials.class, (Item)item, (Authentication)ACL.SYSTEM2, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)}));
    }

    private static void ensureArtifactType(String scriptPath, Manifest manifest) {
        if (!CpsOrasFlowDefinition.hasScriptPath(scriptPath) && !Objects.equals(ARTIFACT_TYPE_SCRIPT.getMediaType(), manifest.getArtifactType().getMediaType())) {
            throw new IllegalArgumentException("The container reference does not point to a valid pipeline manifest. Make sure to set %s artifact type when pushing the artifact. Found artifact type %s instead".formatted(ARTIFACT_TYPE_SCRIPT, manifest.getArtifactType()));
        }
        if (CpsOrasFlowDefinition.hasScriptPath(scriptPath) && !Objects.equals(ARTIFACT_TYPE_REPO.getMediaType(), manifest.getArtifactType().getMediaType())) {
            throw new IllegalArgumentException("The container reference does not point to a valid repository manifest. Make sure to set %s artifact type when pushing the artifact. Found artifact type %s instead".formatted(ARTIFACT_TYPE_REPO, manifest.getArtifactType()));
        }
    }

    @Extension
    @Symbol(value={"cpsOras"})
    public static class DescriptorImpl
    extends FlowDefinitionDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Pipeline script from ORAS";
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeEmptyValue().includeMatchingAs(ACL.SYSTEM2, item, StandardUsernameCredentials.class, Collections.emptyList(), CredentialsMatchers.instanceOf(StandardUsernameCredentials.class)).includeCurrentValue(credentialsId);
        }
    }
}

