/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.agent_build_history;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.Run;
import io.jenkins.plugins.agent_build_history.Messages;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class AgentExecution
implements Comparable<AgentExecution> {
    private final Run<?, ?> run;
    private final Set<FlowNodeExecution> flowNodes = Collections.synchronizedSet(new TreeSet());

    public AgentExecution(Run<?, ?> run) {
        this.run = run;
    }

    @NonNull
    public Run<?, ?> getRun() {
        return this.run;
    }

    public void addFlowNode(FlowNode node, String nodeName) {
        FlowNodeExecution exec = new FlowNodeExecution(node.getId(), nodeName);
        this.flowNodes.add(exec);
    }

    public Set<FlowNodeExecution> getFlowNodes() {
        return Collections.unmodifiableSet(this.flowNodes);
    }

    private static long getNodeTime(FlowNode node) {
        if (node == null) {
            return 0L;
        }
        TimingAction timingAction = (TimingAction)node.getAction(TimingAction.class);
        if (timingAction != null) {
            return timingAction.getStartTime();
        }
        return 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentExecution execution = (AgentExecution)o;
        return Objects.equals(this.run, execution.run);
    }

    public int hashCode() {
        return Objects.hash(this.run);
    }

    @Override
    public int compareTo(AgentExecution o) {
        int compare = Long.compare(o.run.getStartTimeInMillis(), this.run.getStartTimeInMillis());
        if (compare == 0) {
            return o.run.getFullDisplayName().compareToIgnoreCase(this.run.getFullDisplayName());
        }
        return compare;
    }

    public class FlowNodeExecution
    implements Comparable<FlowNodeExecution> {
        private final String nodeId;
        private Status status;
        private String nodeName;
        private final long startTime;

        public FlowNodeExecution(String nodeId, String nodeName) {
            this.nodeId = nodeId;
            this.nodeName = nodeName;
            this.startTime = AgentExecution.getNodeTime(this.getStartNode());
        }

        @CheckForNull
        private FlowNode getStartNode() {
            Run<?, ?> run = AgentExecution.this.getRun();
            FlowExecution execution = ((WorkflowRun)run).getExecution();
            if (execution != null) {
                try {
                    return execution.getNode(this.nodeId);
                }
                catch (IOException e) {
                    return null;
                }
            }
            return null;
        }

        private FlowNode getEndNode() {
            Run<?, ?> run = AgentExecution.this.getRun();
            FlowExecution execution = ((WorkflowRun)run).getExecution();
            if (execution != null) {
                try {
                    FlowNode node = execution.getNode(this.nodeId);
                    if (node instanceof BlockStartNode) {
                        BlockStartNode bsn = (BlockStartNode)node;
                        return bsn.getEndNode();
                    }
                }
                catch (IOException e) {
                    return null;
                }
            }
            return null;
        }

        public String getDurationString() {
            long endTime = AgentExecution.getNodeTime(this.getEndNode());
            if (endTime == 0L) {
                return Messages.InProgressDuration(Util.getTimeSpanString((long)(System.currentTimeMillis() - this.startTime)));
            }
            return Util.getTimeSpanString((long)(endTime - this.startTime));
        }

        public long getDuration() {
            long endTime = AgentExecution.getNodeTime(this.getEndNode());
            if (endTime == 0L) {
                return Math.max(System.currentTimeMillis() - this.startTime, 0L);
            }
            return Math.max(endTime - this.startTime, 0L);
        }

        @Override
        public int compareTo(FlowNodeExecution o) {
            int compare = Long.compare(o.startTime, this.startTime);
            if (compare == 0) {
                return this.nodeId.compareTo(o.nodeId);
            }
            return compare;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FlowNodeExecution that = (FlowNodeExecution)o;
            return Objects.equals(this.startTime, that.startTime);
        }

        public int hashCode() {
            return Objects.hash(this.startTime);
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public Status getFlowNodeStatus() {
            long endTime = AgentExecution.getNodeTime(this.getEndNode());
            if (endTime == 0L) {
                return Status.RUNNING;
            }
            if (this.status == null) {
                Run<?, ?> run = AgentExecution.this.getRun();
                if (!(run instanceof WorkflowRun)) {
                    return Status.UNKNOWN;
                }
                WorkflowRun wfr = (WorkflowRun)run;
                FlowExecution flowExecution = wfr.getExecution();
                if (flowExecution == null) {
                    return Status.UNKNOWN;
                }
                try {
                    BlockStartNode bsn;
                    BlockEndNode endNode;
                    FlowNode node = flowExecution.getNode(this.nodeId);
                    if (node instanceof BlockStartNode && (endNode = (bsn = (BlockStartNode)node).getEndNode()) != null) {
                        ErrorAction errorAction = endNode.getError();
                        this.status = errorAction != null ? Status.FAILURE : Status.SUCCESS;
                        return this.status;
                    }
                }
                catch (IOException e) {
                    return Status.UNKNOWN;
                }
                return Status.UNKNOWN;
            }
            return this.status;
        }

        public String getStartTimeString() {
            return Util.XS_DATETIME_FORMATTER2.format(Instant.ofEpochMilli(this.startTime));
        }

        public String getStartTimeSince() {
            long duration = new GregorianCalendar().getTimeInMillis() - this.startTime;
            return Util.getTimeSpanString((long)duration);
        }
    }

    public static enum Status {
        UNKNOWN(false, Messages.Unknown()),
        SUCCESS(false, Messages.Success()),
        RUNNING(false, Messages.StillRunning()),
        FAILURE(true, Messages.Failure());

        private final boolean worse;
        private final String message;

        private Status(boolean worse, String message) {
            this.worse = worse;
            this.message = message;
        }

        public boolean isWorse() {
            return this.worse;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

