/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.oidc_backchannel_logout;

import com.nimbusds.jwt.SignedJWT;
import hudson.Extension;
import hudson.model.User;
import io.jenkins.plugins.oidc_backchannel_logout.SessionTracker;
import jakarta.servlet.http.HttpSession;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.SecurityListener;
import org.jenkinsci.plugins.oic.OicCredentials;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class OidcSessionListener
extends SecurityListener {
    private static final Logger LOGGER = Logger.getLogger(OidcSessionListener.class.getName());

    protected void loggedIn(String username) {
        try {
            String idToken;
            User user = User.get((String)username, (boolean)false, null);
            if (user == null) {
                return;
            }
            OicCredentials credentials = (OicCredentials)user.getProperty(OicCredentials.class);
            if (credentials != null && (idToken = credentials.getIdToken()) != null) {
                SignedJWT jwt = SignedJWT.parse((String)idToken);
                String sid = (String)jwt.getJWTClaimsSet().getClaim("sid");
                StaplerRequest2 req = Stapler.getCurrentRequest2();
                if (req != null) {
                    HttpSession session = req.getSession(false);
                    if (sid != null && session != null) {
                        SessionTracker.track(sid, session);
                        LOGGER.fine("Successfully mapped SID to Jenkins Session.");
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to track OIDC session: {0}", e.getMessage());
        }
    }
}

