/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.twofactor.jenkins.tfaMethodsConfig;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.util.FormApply;
import io.jenkins.plugins.twofactor.constants.MoGlobalConfigConstant;
import io.jenkins.plugins.twofactor.jenkins.MoFilter;
import io.jenkins.plugins.twofactor.jenkins.MoGlobalConfig;
import io.jenkins.plugins.twofactor.jenkins.MoUserAuth;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class MoOtpOverEmailConfig
extends UserProperty
implements Action {
    private static final Logger LOGGER = Logger.getLogger(MoOtpOverEmailConfig.class.getName());
    public Boolean isConfigured;

    @DataBoundConstructor
    public MoOtpOverEmailConfig(Boolean isConfigured) {
        this.isConfigured = isConfigured;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "OTP over email";
    }

    public String getUrlName() {
        return "otpOverEmailConfig";
    }

    @RequirePOST
    public void doReset(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.READ);
        try {
            MoOtpOverEmailConfig otpOverEmailConfig = (MoOtpOverEmailConfig)this.user.getProperty(MoOtpOverEmailConfig.class);
            otpOverEmailConfig.setConfigured(false);
            LOGGER.fine("Resetting the OTP over email authentication method");
            this.user.save();
        }
        catch (Exception e) {
            LOGGER.fine("Error in resetting the OTP over email config");
        }
        FormApply.success((String)req.getReferer()).generateResponse(req, rsp, null);
    }

    public Boolean isConfigured() {
        return this.isConfigured;
    }

    public void setConfigured(Boolean Configured) {
        this.isConfigured = Configured;
    }

    @Extension
    public static class DescriptorImpl
    extends UserPropertyDescriptor {
        public DescriptorImpl() {
            super(MoOtpOverEmailConfig.class);
        }

        public UserProperty newInstance(User user) {
            return new MoOtpOverEmailConfig(false);
        }

        @SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"}, justification="Intentionally returning null to hide from UI")
        public String getDisplayName() {
            return null;
        }

        public Boolean showInUserProfile() {
            return MoFilter.moPluginSettings.getOrDefault(MoGlobalConfigConstant.AdminConfiguration.ENABLE_2FA_FOR_ALL_USERS.getKey(), false) != false && MoGlobalConfig.get().isEnableOtpOverEmailAuthentication() != false;
        }

        public String getUserId() {
            User currentUser = User.current();
            if (currentUser == null) {
                return "";
            }
            return currentUser.getId();
        }

        public String getContextPath() {
            return MoUserAuth.getContextPath();
        }
    }
}

