/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.twofactor.jenkins.tfaMethodsAuth;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.User;
import hudson.util.FormApply;
import io.jenkins.plugins.twofactor.constants.MoPluginUrls;
import io.jenkins.plugins.twofactor.jenkins.MoUserAuth;
import io.jenkins.plugins.twofactor.jenkins.tfaMethodsConfig.MoSecurityQuestionConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class MoSecurityQuestionAuth
implements Action {
    private static final Logger LOGGER = Logger.getLogger(MoSecurityQuestionAuth.class.getName());
    int firstRandomSecurityQuestionIndex = 0;
    int secondRandomSecurityQuestionIndex = 1;
    private String[] securityQuestionArray;
    private String[] securityAnswerArray;
    public Map<String, Boolean> showWrongCredentialWarning = new HashMap<String, Boolean>();
    private static final Random RANDOM = new Random();
    private final User user = User.current();

    public MoSecurityQuestionAuth() {
        try {
            if (this.user != null) {
                MoSecurityQuestionConfig securityQuestion = (MoSecurityQuestionConfig)this.user.getProperty(MoSecurityQuestionConfig.class);
                this.securityQuestionArray = new String[]{securityQuestion.getFirstSecurityQuestion(this.user), securityQuestion.getSecondSecurityQuestion(this.user), securityQuestion.getCustomSecurityQuestion(this.user)};
                this.securityAnswerArray = new String[]{securityQuestion.getFirstSecurityQuestionAnswer(this.user), securityQuestion.getSecondSecurityQuestionAnswer(this.user), securityQuestion.getCustomSecurityQuestionAnswer(this.user)};
            }
        }
        catch (Exception e) {
            LOGGER.fine("Error in getting security questions and answers for user authentication " + e.getMessage());
        }
    }

    public String getIconFileName() {
        return "";
    }

    public String getDisplayName() {
        return MoPluginUrls.Urls.MO_SECURITY_QUESTION_AUTH.getUrl();
    }

    public String getUrlName() {
        return MoPluginUrls.Urls.MO_SECURITY_QUESTION_AUTH.getUrl();
    }

    public String getContextPath() {
        return MoUserAuth.getContextPath();
    }

    public String getUserId() {
        return this.user != null ? this.user.getId() : "";
    }

    private void initializeRandomTwoIndex() {
        this.firstRandomSecurityQuestionIndex = RANDOM.nextInt(3);
        this.secondRandomSecurityQuestionIndex = RANDOM.nextInt(2);
        if (this.secondRandomSecurityQuestionIndex >= this.firstRandomSecurityQuestionIndex) {
            ++this.secondRandomSecurityQuestionIndex;
        }
    }

    public void doInitializeRandomTwoIndex() {
        this.initializeRandomTwoIndex();
    }

    public String getFirstRandomSecurityQuestion() {
        return this.securityQuestionArray[this.firstRandomSecurityQuestionIndex];
    }

    public String getSecondRandomSecurityQuestion() {
        return this.securityQuestionArray[this.secondRandomSecurityQuestionIndex];
    }

    private String getFirstRandomSecurityQuestionAnswer() {
        return this.securityAnswerArray[this.firstRandomSecurityQuestionIndex];
    }

    private String getSecondRandomSecurityQuestionAnswer() {
        return this.securityAnswerArray[this.secondRandomSecurityQuestionIndex];
    }

    public boolean getShowWrongCredentialWarning() {
        return this.showWrongCredentialWarning.getOrDefault(this.user.getId(), false);
    }

    private boolean validateUserAnswers(JSONObject formData) {
        return formData.get("userFirstAuthenticationAnswer").toString().equals(this.getFirstRandomSecurityQuestionAnswer()) && formData.get("userSecondAuthenticationAnswer").toString().equals(this.getSecondRandomSecurityQuestionAnswer());
    }

    @RequirePOST
    public void doSecurityQuestionAuthenticate(StaplerRequest staplerRequest, StaplerResponse staplerResponse) throws Exception {
        Jenkins.get().checkPermission(Jenkins.READ);
        JSONObject formData = staplerRequest.getSubmittedForm();
        HttpSession session = staplerRequest.getSession(false);
        String redirectUrl = Jenkins.get().getRootUrl();
        LOGGER.fine("Authenticating user tfa security answers");
        try {
            if (this.user == null) {
                return;
            }
            if (this.validateUserAnswers(formData)) {
                LOGGER.fine(this.user.getId() + " user is authentic");
                redirectUrl = MoUserAuth.allow2FaAccessAndRedirect(session, this.user, this.showWrongCredentialWarning);
            } else {
                LOGGER.fine("User is not authentic");
                redirectUrl = "./";
                this.showWrongCredentialWarning.put(this.user.getId(), true);
            }
            if (redirectUrl == null) {
                redirectUrl = Jenkins.get().getRootUrl();
            }
            LOGGER.fine("Redirecting" + this.user.getId() + " from  MoSecurityQuestionAuth to " + redirectUrl);
            FormApply.success((String)redirectUrl).generateResponse(staplerRequest, staplerResponse, null);
        }
        catch (Exception e) {
            LOGGER.fine("Exception while authenticating/Logging out the user " + e.getMessage());
        }
    }
}

