/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.twofactor.jenkins.tfaMethodsAuth;

import hudson.Util;
import hudson.model.Action;
import hudson.model.User;
import hudson.tasks.Mailer;
import hudson.tasks.SMTPAuthentication;
import hudson.util.FormApply;
import hudson.util.Secret;
import io.jenkins.plugins.twofactor.constants.MoGlobalConfigConstant;
import io.jenkins.plugins.twofactor.constants.MoPluginUrls;
import io.jenkins.plugins.twofactor.jenkins.MoFilter;
import io.jenkins.plugins.twofactor.jenkins.MoGlobalConfig;
import io.jenkins.plugins.twofactor.jenkins.MoUserAuth;
import io.jenkins.plugins.twofactor.jenkins.tfaMethodsConfig.MoOtpOverEmailConfig;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class MoOtpOverEmailAuth
implements Action {
    private static final Logger LOGGER = Logger.getLogger(MoOtpOverEmailAuth.class.getName());
    private static final Map<String, String> sentOtp = new HashMap<String, String>();
    public Map<String, Boolean> showWrongCredentialWarning = new HashMap<String, Boolean>();
    private static final Random RANDOM = new Random();
    private final User user = User.current();

    public String getIconFileName() {
        return "";
    }

    public String getDisplayName() {
        return MoPluginUrls.Urls.MO_OTP_OVER_EMAIL_AUTH.getUrl();
    }

    public String getUrlName() {
        return MoPluginUrls.Urls.MO_OTP_OVER_EMAIL_AUTH.getUrl();
    }

    public String getContextPath() {
        return MoUserAuth.getContextPath();
    }

    public boolean isOtpSentToUser() {
        return !sentOtp.getOrDefault(this.user.getId(), "").isEmpty();
    }

    public String getUserEmailAddress() {
        return ((Mailer.UserProperty)this.user.getProperty(Mailer.UserProperty.class)).getAddress();
    }

    public String getUserId() {
        return this.user != null ? this.user.getId() : "";
    }

    public boolean isUserAuthenticatedFromTfa() {
        return MoFilter.userAuthenticationStatus.getOrDefault(this.user.getId(), false);
    }

    public boolean getShowWrongCredentialWarning() {
        return this.showWrongCredentialWarning.getOrDefault(this.user.getId(), false);
    }

    public boolean isOtpOverEmailConfigured() {
        MoOtpOverEmailConfig otpOverEmailConfig = (MoOtpOverEmailConfig)this.user.getProperty(MoOtpOverEmailConfig.class);
        return otpOverEmailConfig != null && otpOverEmailConfig.isConfigured() != false;
    }

    private String createOtp(int len) {
        String numbers = "0123456789";
        char[] otp = new char[len];
        for (int i = 0; i < len; ++i) {
            otp[i] = numbers.charAt(RANDOM.nextInt(numbers.length()));
        }
        return String.valueOf(otp);
    }

    private static Session createSession(String smtpHost, String smtpPort, boolean useSsl, boolean useTls, String smtpAuthUserName, Secret smtpAuthPassword) {
        String port;
        String SMTP_PORT_PROPERTY = "mail.smtp.port";
        String SMTP_SOCKETFACTORY_PORT_PROPERTY = "mail.smtp.socketFactory.port";
        String SMTP_SSL_ENABLE_PROPERTY = "mail.smtp.ssl.enable";
        String SMTP_SSL_CHECKSERVERIDENTITY = "mail.smtp.ssl.checkserveridentity";
        smtpHost = Util.fixEmptyAndTrim((String)smtpHost);
        smtpPort = Util.fixEmptyAndTrim((String)smtpPort);
        smtpAuthUserName = Util.fixEmptyAndTrim((String)smtpAuthUserName);
        Properties props = new Properties(System.getProperties());
        if (smtpHost != null) {
            props.put("mail.smtp.host", smtpHost);
        }
        if (smtpPort != null) {
            props.put("mail.smtp.port", smtpPort);
        }
        if (useSsl) {
            if (props.getProperty("mail.smtp.socketFactory.port") == null) {
                port = smtpPort == null ? "465" : smtpPort;
                props.put("mail.smtp.port", port);
                props.put("mail.smtp.socketFactory.port", port);
            }
            if (props.getProperty("mail.smtp.ssl.enable") == null) {
                props.put("mail.smtp.ssl.enable", "true");
                props.put("mail.smtp.ssl.checkserveridentity", (Object)true);
            }
            props.put("mail.smtp.socketFactory.fallback", "false");
            if (props.getProperty("mail.smtp.ssl.checkserveridentity") == null) {
                props.put("mail.smtp.ssl.checkserveridentity", "true");
            }
        }
        if (useTls) {
            if (props.getProperty("mail.smtp.socketFactory.port") == null) {
                port = smtpPort == null ? "587" : smtpPort;
                props.put("mail.smtp.port", port);
                props.put("mail.smtp.socketFactory.port", port);
            }
            props.put("mail.smtp.starttls.enable", "true");
            props.put("mail.smtp.starttls.required", "true");
        }
        if (smtpAuthUserName != null) {
            props.put("mail.smtp.auth", "true");
        }
        props.put("mail.smtp.timeout", "60000");
        props.put("mail.smtp.connectiontimeout", "60000");
        return Session.getInstance((Properties)props, (Authenticator)MoOtpOverEmailAuth.getAuthenticator(smtpAuthUserName, Secret.toString((Secret)smtpAuthPassword)));
    }

    private static Authenticator getAuthenticator(final String smtpAuthUserName, final String smtpAuthPassword) {
        if (smtpAuthUserName == null) {
            return null;
        }
        return new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(smtpAuthUserName, smtpAuthPassword);
            }
        };
    }

    public void sendMail() {
        try {
            String template;
            LOGGER.fine("Sending mail for otpOverEmail method");
            Mailer.DescriptorImpl mailerDescriptor = Mailer.descriptor();
            String smtpHost = mailerDescriptor.getSmtpHost();
            String senderEmailAddress = MoGlobalConfig.get().getOtpOverEmailDto().getSenderEmailAddress();
            SMTPAuthentication MailerAuthentication = mailerDescriptor.getAuthentication();
            String username = MailerAuthentication != null ? MailerAuthentication.getUsername() : null;
            Secret password = MailerAuthentication != null ? MailerAuthentication.getPassword() : null;
            boolean useSsl = mailerDescriptor.getUseSsl();
            boolean useTls = mailerDescriptor.getUseTls();
            String smtpPort = mailerDescriptor.getSmtpPort();
            String charset = mailerDescriptor.getCharset();
            String sendTestMailTo = this.getUserEmailAddress();
            MimeMessage msg = new MimeMessage(MoOtpOverEmailAuth.createSession(smtpHost, smtpPort, useSsl, useTls, username, password));
            String otpToSend = this.createOtp(5);
            sentOtp.put(this.user.getId(), otpToSend);
            String subject = MoGlobalConfig.get().getAdvancedSettings().getCustomOTPEmailSubject();
            if (StringUtils.isBlank((String)subject)) {
                subject = MoGlobalConfigConstant.AdvanceSettingsConstants.DEFAULT_OTP_EMAIL_SUBJECT.getValue();
            }
            if (StringUtils.isBlank((String)(template = MoGlobalConfig.get().getAdvancedSettings().getCustomOTPEmailTemplate()))) {
                template = MoGlobalConfigConstant.AdvanceSettingsConstants.DEFAULT_OTP_EMAIL_TEMPLATE.getValue();
            }
            if (subject.contains("$username")) {
                subject = subject.replace("$username", this.user.getId());
            }
            if (subject.contains("$otp")) {
                subject = subject.replace("$otp", sentOtp.get(this.user.getId()));
            }
            if (template.contains("$username")) {
                template = template.replace("$username", this.user.getId());
            }
            if (template.contains("$otp")) {
                template = template.replace("$otp", sentOtp.get(this.user.getId()));
            }
            msg.setSubject(subject);
            msg.setContent((Object)template, "text/html");
            msg.setFrom((Address)Mailer.stringToAddress((String)senderEmailAddress, (String)charset));
            if (StringUtils.isNotBlank((String)sendTestMailTo)) {
                msg.setReplyTo(new Address[]{Mailer.stringToAddress((String)sendTestMailTo, (String)charset)});
            }
            msg.setSentDate(new Date());
            msg.setRecipient(Message.RecipientType.TO, (Address)Mailer.stringToAddress((String)sendTestMailTo, (String)charset));
            Transport.send((Message)msg);
        }
        catch (RuntimeException e) {
            LOGGER.fine("Run time exception occur" + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            LOGGER.fine("Failed in sending mail, error is " + e.getMessage());
        }
    }

    @RequirePOST
    public void doResendOtp(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException {
        Jenkins.get().checkPermission(Jenkins.READ);
        try {
            this.sendMail();
        }
        catch (Exception e) {
            LOGGER.fine("Failed to send mail to user " + e.getMessage());
        }
        FormApply.success((String)"./").generateResponse(req, rsp, null);
    }

    @RequirePOST
    public void doSaveOrValidateOtpOverEmailConfig(StaplerRequest req, StaplerResponse rsp) throws Exception {
        Jenkins.get().checkPermission(Jenkins.READ);
        if (sentOtp.get(this.user.getId()) == null) {
            return;
        }
        boolean isOtpOverEmailConfigured = this.isOtpOverEmailConfigured();
        JSONObject json = req.getSubmittedForm();
        Object redirectUrl = req.getContextPath() + "./";
        try {
            String userInputOtp = json.getString("emailOtpForVerification");
            HttpSession session = req.getSession(false);
            String LoggingAction = "Authenticating the OTPOverEmail  OTP to login user";
            if (!isOtpOverEmailConfigured) {
                LoggingAction = "Authenticating the OTP to set OTPOverEmailConfig for user";
            }
            LOGGER.fine(LoggingAction);
            MoOtpOverEmailConfig otpOverEmailConfig = (MoOtpOverEmailConfig)this.user.getProperty(MoOtpOverEmailConfig.class);
            if (userInputOtp.equals(sentOtp.get(this.user.getId()))) {
                LOGGER.fine("Otp is authentic");
                otpOverEmailConfig.setConfigured(true);
                sentOtp.remove(this.user.getId());
                redirectUrl = MoUserAuth.allow2FaAccessAndRedirect(session, this.user, this.showWrongCredentialWarning);
            } else {
                LOGGER.fine("Entered wrong otp for otpOverEmailConfig");
                redirectUrl = "./";
                this.showWrongCredentialWarning.put(this.user.getId(), true);
            }
            if (!isOtpOverEmailConfigured) {
                this.user.save();
            }
            if (redirectUrl == null) {
                redirectUrl = Jenkins.get().getRootUrl();
            }
            LOGGER.fine("Redirecting" + this.user.getId() + " from otpOverEmailAuth to " + (String)redirectUrl);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.fine("Something went wrong in Otp Over Email, Form is not filled correctly ");
            throw new Exception("Something went wrong in Otp Over Email, exception is " + e.getMessage());
        }
        LOGGER.fine("Redirecting user from otpOverEmailAuth to " + (String)redirectUrl);
        FormApply.success((String)redirectUrl).generateResponse(req, rsp, null);
    }
}

