/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.twofactor.jenkins;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import io.jenkins.plugins.twofactor.constants.MoGlobalConfigConstant;
import io.jenkins.plugins.twofactor.constants.MoPluginUrls;
import io.jenkins.plugins.twofactor.jenkins.MoFilter;
import io.jenkins.plugins.twofactor.jenkins.MoGlobalConfig;
import io.jenkins.plugins.twofactor.jenkins.MoUserAuth;
import io.jenkins.plugins.twofactor.jenkins.tfaMethodsConfig.MoOtpOverEmailConfig;
import io.jenkins.plugins.twofactor.jenkins.tfaMethodsConfig.MoSecurityQuestionConfig;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.springframework.lang.NonNull;

@Extension
public class MoUserConfig
extends UserProperty
implements Action {
    private static final Logger LOGGER = Logger.getLogger(MoUserConfig.class.getName());

    public String getIconFileName() {
        try {
            User user = User.current();
            if (user == null || !MoFilter.moPluginSettings.getOrDefault(MoGlobalConfigConstant.AdminConfiguration.ENABLE_2FA_FOR_ALL_USERS.getKey(), false).booleanValue()) {
                return null;
            }
            StaplerRequest request = Stapler.getCurrentRequest();
            String regex = ".*/user/([^/]+).*";
            Matcher matcher = Pattern.compile(regex).matcher(request.getRequestURI());
            if (matcher.matches() && user.getId().equals(matcher.group(1))) {
                return "/plugin/miniorange-two-factor/images/tfaIcon.png";
            }
        }
        catch (Exception e) {
            LOGGER.fine("Exception in showing user security question, exception is " + e.getMessage());
        }
        return null;
    }

    public String getDisplayName() {
        return "2fa configuration";
    }

    public String getUrlName() {
        return MoPluginUrls.Urls.MO_USER_CONFIG.getUrl();
    }

    public boolean isSecurityQuestionConfigurationIsEnabled() {
        return MoGlobalConfig.get().isEnableSecurityQuestionsAuthentication();
    }

    public static String getContextPath() {
        return MoUserAuth.getContextPath();
    }

    public boolean showSecurityQuestionForConfiguration() {
        MoSecurityQuestionConfig securityQuestionConfig = (MoSecurityQuestionConfig)this.user.getProperty(MoSecurityQuestionConfig.class);
        boolean isConfigured = securityQuestionConfig != null && securityQuestionConfig.isConfigured();
        boolean isEnabled = this.isSecurityQuestionConfigurationIsEnabled();
        return !isConfigured && isEnabled;
    }

    public boolean isOtpOverEmailIsEnabled() {
        return MoGlobalConfig.get().isEnableOtpOverEmailAuthentication();
    }

    public boolean showOtpOverEmailForConfiguration() {
        MoOtpOverEmailConfig otpOverEmailConfig = (MoOtpOverEmailConfig)this.user.getProperty(MoOtpOverEmailConfig.class);
        boolean isConfigured = otpOverEmailConfig != null && otpOverEmailConfig.isConfigured() != false;
        boolean isEnabled = this.isOtpOverEmailIsEnabled();
        return !isConfigured && isEnabled;
    }

    public boolean isUserAuthenticatedFromTfa() {
        User user = User.current();
        assert (user != null);
        return MoFilter.userAuthenticationStatus.getOrDefault(user.getId(), false);
    }

    public String getUserId() {
        return this.user != null ? this.user.getId() : "";
    }

    public String getBaseUrl() {
        return Jenkins.get().getRootUrl();
    }

    public UserPropertyDescriptor getDescriptor() {
        return new DescriptorImpl();
    }

    @Extension
    public static class DescriptorImpl
    extends UserPropertyDescriptor {
        public DescriptorImpl() {
            super(MoUserConfig.class);
        }

        public UserProperty newInstance(User user) {
            return new MoUserConfig();
        }

        @NonNull
        public String getDisplayName() {
            return "2fa configuration";
        }

        public Boolean showInUserProfile() {
            return MoFilter.moPluginSettings.getOrDefault(MoGlobalConfigConstant.AdminConfiguration.ENABLE_2FA_FOR_ALL_USERS.getKey(), false);
        }

        public String getContextPath() {
            return MoUserAuth.getContextPath();
        }

        public String getUserId() {
            User currentUser = User.current();
            if (currentUser == null) {
                return "";
            }
            return currentUser.getId();
        }
    }
}

