/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.twofactor.jenkins;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.RootAction;
import hudson.model.User;
import io.jenkins.plugins.twofactor.constants.MoGlobalConfigConstant;
import io.jenkins.plugins.twofactor.constants.MoPluginUrls;
import io.jenkins.plugins.twofactor.jenkins.MoFilter;
import io.jenkins.plugins.twofactor.jenkins.MoGlobalConfig;
import io.jenkins.plugins.twofactor.jenkins.tfaMethodsAuth.MoOtpOverEmailAuth;
import io.jenkins.plugins.twofactor.jenkins.tfaMethodsAuth.MoSecurityQuestionAuth;
import io.jenkins.plugins.twofactor.jenkins.tfaMethodsConfig.MoOtpOverEmailConfig;
import io.jenkins.plugins.twofactor.jenkins.tfaMethodsConfig.MoSecurityQuestionConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class MoUserAuth
implements RootAction,
Describable<MoUserAuth> {
    private static final Logger LOGGER = Logger.getLogger(MoUserAuth.class.getName());
    Map<String, MoSecurityQuestionAuth> moSecurityQuestionAuthMap = new HashMap<String, MoSecurityQuestionAuth>();
    Map<String, MoOtpOverEmailAuth> moOtpOverEmailAuthMap = new HashMap<String, MoOtpOverEmailAuth>();

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return MoPluginUrls.Urls.MO_USER_AUTH.getUrl();
    }

    public String getUrlName() {
        return MoPluginUrls.Urls.MO_USER_AUTH.getUrl();
    }

    public static String getContextPath() {
        StaplerRequest req = Stapler.getCurrentRequest();
        return req.getContextPath();
    }

    public String getBaseUrl() {
        return Jenkins.get().getRootUrl();
    }

    public String getUserId() {
        User currentUser = User.current();
        if (currentUser == null) {
            return "";
        }
        return currentUser.getId();
    }

    public MoSecurityQuestionAuth getSecurityQuestionAuth() {
        if (this.moSecurityQuestionAuthMap.get(this.getUserId()) == null) {
            this.moSecurityQuestionAuthMap.put(this.getUserId(), new MoSecurityQuestionAuth());
        }
        return this.moSecurityQuestionAuthMap.get(this.getUserId());
    }

    public MoOtpOverEmailAuth getOtpOverEmailAuth() {
        if (this.moOtpOverEmailAuthMap.get(this.getUserId()) == null) {
            this.moOtpOverEmailAuthMap.put(this.getUserId(), new MoOtpOverEmailAuth());
        }
        return this.moOtpOverEmailAuthMap.get(this.getUserId());
    }

    public void cleanUserAuthResource(String userId) {
        this.moSecurityQuestionAuthMap.remove(userId);
        this.moOtpOverEmailAuthMap.remove(userId);
    }

    public boolean showSecurityQuestionForConfiguration() {
        User user = User.current();
        assert (user != null);
        MoSecurityQuestionConfig securityQuestionConfig = (MoSecurityQuestionConfig)user.getProperty(MoSecurityQuestionConfig.class);
        boolean isConfigured = securityQuestionConfig != null && securityQuestionConfig.isConfigured();
        boolean isEnabled = MoGlobalConfig.get().isEnableSecurityQuestionsAuthentication();
        return isConfigured && isEnabled;
    }

    public boolean showOtpOverEmailForConfiguration() {
        User user = User.current();
        assert (user != null);
        MoOtpOverEmailConfig otpOverEmailConfig = (MoOtpOverEmailConfig)user.getProperty(MoOtpOverEmailConfig.class);
        boolean isConfigured = otpOverEmailConfig != null && otpOverEmailConfig.isConfigured() != false;
        boolean isEnabled = MoGlobalConfig.get().isEnableOtpOverEmailAuthentication();
        return isConfigured && isEnabled;
    }

    public static String allow2FaAccessAndRedirect(HttpSession session, User user, Map<String, Boolean> showWrongCredentialWarning) {
        String redirectUrl;
        if (session != null) {
            redirectUrl = (String)session.getAttribute("tfaRelayState");
            session.removeAttribute("tfaRelayState");
            session.setAttribute(user.getId() + MoGlobalConfigConstant.UtilityGlobalConstants.SESSION_2FA_VERIFICATION.getKey(), (Object)"true");
            MoFilter.userAuthenticationStatus.put(user.getId(), true);
            MoUserAuth moUserAuth = (MoUserAuth)ExtensionList.lookupSingleton(MoUserAuth.class);
            moUserAuth.cleanUserAuthResource(user.getId());
            showWrongCredentialWarning.put(user.getId(), false);
        } else {
            LOGGER.fine("Session is null, hence not authenticating the user");
            redirectUrl = "./";
        }
        return redirectUrl;
    }

    public Descriptor<MoUserAuth> getDescriptor() {
        return Jenkins.get().getDescriptorOrDie(this.getClass());
    }
}

