/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.twofactor.jenkins;

import hudson.Extension;
import hudson.model.User;
import hudson.security.csrf.CrumbExclusion;
import io.jenkins.plugins.twofactor.constants.MoGlobalConfigConstant;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@Extension
public class MoTfaCrumbExclusion
extends CrumbExclusion {
    private static final Logger LOGGER = Logger.getLogger(MoTfaCrumbExclusion.class.getName());

    public boolean process(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpSession session = request.getSession();
        User user = User.current();
        if (user == null || session == null || this.ignoreCrumbCheck(session, user.getId())) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        return false;
    }

    private boolean ignoreCrumbCheck(HttpSession session, String userId) {
        String sessionAttributeKey = userId + MoGlobalConfigConstant.UtilityGlobalConstants.SESSION_2FA_VERIFICATION.getKey();
        Object tfaVerificationAttribute = session.getAttribute(sessionAttributeKey);
        if (tfaVerificationAttribute == null) {
            return true;
        }
        return !Boolean.parseBoolean(tfaVerificationAttribute.toString());
    }
}

