/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.twofactor.jenkins;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.FormApply;
import io.jenkins.plugins.twofactor.constants.MoPluginUrls;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.lang.NonNull;

public class MoIPRestrictionsConfig
implements Action,
Describable<MoIPRestrictionsConfig> {
    private static final Logger LOGGER = Logger.getLogger(MoIPRestrictionsConfig.class.getName());

    public String getIconFileName() {
        return "symbol-lock-closed";
    }

    public String getDisplayName() {
        return "IP Restrictions Configuration";
    }

    public String getUrlName() {
        return MoPluginUrls.Urls.MO_TFA_IP_RESTRICTIONS_CONFIG.getUrl();
    }

    public Descriptor<MoIPRestrictionsConfig> getDescriptor() {
        Jenkins jenkins = Jenkins.get();
        return jenkins.getDescriptorOrDie(this.getClass());
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doSaveWhitelistIp(StaplerRequest request, StaplerResponse response) {
        try {
            FormApply.applyResponse((String)"notificationBar.show('Available in Premium version', notificationBar.WARNING);").generateResponse(request, response, (Object)this);
        }
        catch (IOException | ServletException e) {
            LOGGER.fine("Failed to process whitelist save request");
        }
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doSaveBlacklistIp(StaplerRequest request, StaplerResponse response) throws ServletException, IOException {
        try {
            FormApply.applyResponse((String)"notificationBar.show('Available in Premium version', notificationBar.WARNING);").generateResponse(request, response, (Object)this);
        }
        catch (IOException | ServletException e) {
            LOGGER.fine("Failed to process blacklist save request");
        }
    }

    @RequirePOST
    public void doShowIp(StaplerRequest req, StaplerResponse rsp) {
        try {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String ip = "Unable to fetch IP";
            try {
                ip = req.getRemoteAddr();
            }
            catch (Exception ignored) {
                LOGGER.fine("Failed to fetch remote IP address");
            }
            String js = "const ipSpan=document.getElementById('user-ip'),formBtn=document.querySelector('form[action=\"showIp\"] button');if(ipSpan){ipSpan.textContent='Your IP: " + ip + "'; ipSpan.style.display='inline-block';}if(formBtn) formBtn.style.display='none';setTimeout(()=>{if(ipSpan) ipSpan.style.display='none'; if(formBtn) formBtn.style.display='inline-block';},4000);";
            FormApply.applyResponse((String)js).generateResponse(req, rsp, (Object)this);
        }
        catch (IOException | ServletException e) {
            LOGGER.fine("Failed to process show IP request");
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<MoIPRestrictionsConfig> {
        @NonNull
        public String getDisplayName() {
            return "IP Restrictions Configuration";
        }
    }
}

