/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.twofactor.jenkins;

import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Descriptor;
import io.jenkins.plugins.twofactor.constants.MoGlobalConfigConstant;
import io.jenkins.plugins.twofactor.jenkins.MoFilter;
import io.jenkins.plugins.twofactor.jenkins.MoGlobalAdvancedSettings;
import io.jenkins.plugins.twofactor.jenkins.dto.MoAdvanceSettingsDTO;
import io.jenkins.plugins.twofactor.jenkins.dto.MoOtpOverEmailDto;
import java.io.File;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class MoGlobalConfig
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(MoGlobalConfig.class.getName());
    private Boolean enableTfa;
    private Boolean enableTfaForAllUsers;
    private Boolean enableSecurityQuestionsAuthentication;
    private MoOtpOverEmailDto otpOverEmailDto;
    private MoAdvanceSettingsDTO moAdvancedSettingsDTO;

    public MoGlobalConfig() {
        this.load();
    }

    public Boolean getEnableTfa() {
        return this.enableTfa != null ? this.enableTfa : false;
    }

    public MoGlobalAdvancedSettings getAdvancedSettings() {
        return new MoGlobalAdvancedSettings(MoGlobalConfig.get().getAdvancedSettingsDTO());
    }

    @DataBoundSetter
    public void setEnableTfa(boolean unableTfa) {
        this.enableTfaForAllUsers = this.enableTfa = Boolean.valueOf(unableTfa);
    }

    public Boolean isEnableSecurityQuestionsAuthentication() {
        return this.enableSecurityQuestionsAuthentication != null ? this.enableSecurityQuestionsAuthentication : false;
    }

    @DataBoundSetter
    public void setEnableSecurityQuestionsAuthentication(boolean enableSecurityQuestionsAuthentication) {
        this.enableSecurityQuestionsAuthentication = enableSecurityQuestionsAuthentication;
    }

    public Boolean isEnableOtpOverEmailAuthentication() {
        return this.otpOverEmailDto != null ? this.otpOverEmailDto.getIsEnabled() : false;
    }

    public String getSenderEmailAddress() {
        return this.otpOverEmailDto != null ? this.otpOverEmailDto.getSenderEmailAddress() : "";
    }

    public MoOtpOverEmailDto getOtpOverEmailDto() {
        return this.otpOverEmailDto;
    }

    public MoAdvanceSettingsDTO getAdvancedSettingsDTO() {
        return this.moAdvancedSettingsDTO;
    }

    public void saveMoGlobalConfigViewForm(JSONObject formData) {
        try {
            this.enableTfaForAllUsers = this.enableTfa = Boolean.valueOf(formData.getBoolean("enableTfa"));
            MoFilter.moPluginSettings.put(MoGlobalConfigConstant.AdminConfiguration.ENABLE_2FA_FOR_ALL_USERS.getKey(), this.enableTfa);
            this.enableSecurityQuestionsAuthentication = formData.getBoolean("enableSecurityQuestion");
            if (formData.containsKey((Object)"enableOtpOverEmail")) {
                JSONObject otpOverEmail = formData.getJSONObject("enableOtpOverEmail");
                String senderEmailAddress = otpOverEmail.getString("senderEmailAddress");
                if (senderEmailAddress.isEmpty()) {
                    throw new UnsupportedOperationException("Sender Email address can not be kept as empty");
                }
                this.otpOverEmailDto = new MoOtpOverEmailDto(true, senderEmailAddress);
            } else {
                this.otpOverEmailDto = null;
            }
            if (this.moAdvancedSettingsDTO == null) {
                this.moAdvancedSettingsDTO = new MoAdvanceSettingsDTO(MoGlobalConfigConstant.AdvanceSettingsConstants.DEFAULT_OTP_EMAIL_SUBJECT.getValue(), MoGlobalConfigConstant.AdvanceSettingsConstants.DEFAULT_OTP_EMAIL_TEMPLATE.getValue());
            }
            this.save();
            LOGGER.fine("Saving global configuration ");
        }
        catch (Exception e) {
            LOGGER.fine("Error in saving mo global configuration " + e.getMessage());
        }
    }

    public void saveGlobalAdvancedSettingsForm(JSONObject formData) {
        try {
            LOGGER.fine("Saving advanced setting details");
            String customOTPEmailSubject = formData.getString("customOTPEmailSubject");
            String customOTPEmailTemplate = formData.getString("customOTPEmailTemplate");
            this.moAdvancedSettingsDTO = new MoAdvanceSettingsDTO(customOTPEmailSubject, customOTPEmailTemplate);
            this.save();
        }
        catch (Exception e) {
            LOGGER.fine("Error in saving 2FA global advance settings");
        }
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        try {
            String formPage;
            switch (formPage = formData.getString("formPage")) {
                case "basicConfig": {
                    this.saveMoGlobalConfigViewForm(formData);
                    break;
                }
                case "advanceSettingsConfig": {
                    this.saveGlobalAdvancedSettingsForm(formData);
                    break;
                }
                default: {
                    LOGGER.fine("Error in saving 2FA global settings for " + formPage);
                }
            }
            if (formData.has("enableTfa")) {
                this.saveMoGlobalConfigViewForm(formData);
            }
        }
        catch (Exception e) {
            LOGGER.fine("Not saved 2FA global settings for our plugin");
            return false;
        }
        return true;
    }

    protected XmlFile getConfigFile() {
        File pluginDir = new File(Jenkins.get().getRootDir(), "/plugins/moTfaGlobalConfig");
        return new XmlFile(new File(pluginDir, this.getId() + ".xml"));
    }

    public static MoGlobalConfig get() {
        MoGlobalConfig config;
        try {
            config = (MoGlobalConfig)((Object)GlobalConfiguration.all().get(MoGlobalConfig.class));
        }
        catch (IllegalStateException e) {
            LOGGER.fine("Error in fetching global configuration class " + e.getMessage());
            throw e;
        }
        return config;
    }
}

