/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.twofactor.jenkins;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.FormApply;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.twofactor.constants.MoGlobalConfigConstant;
import io.jenkins.plugins.twofactor.constants.MoPluginUrls;
import io.jenkins.plugins.twofactor.jenkins.MoGlobalConfig;
import io.jenkins.plugins.twofactor.jenkins.dto.MoAdvanceSettingsDTO;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;

public class MoGlobalAdvancedSettings
implements Action,
Describable<MoGlobalAdvancedSettings> {
    private static final Logger LOGGER = Logger.getLogger(MoGlobalAdvancedSettings.class.getName());
    private final MoAdvanceSettingsDTO moAdvanceSettingsDto;

    public MoGlobalAdvancedSettings(MoAdvanceSettingsDTO moAdvanceSettingsDto) {
        this.moAdvanceSettingsDto = moAdvanceSettingsDto;
    }

    public String getIconFileName() {
        return "symbol-settings";
    }

    public String getDisplayName() {
        return "advanced-settings";
    }

    public String getUrlName() {
        return MoPluginUrls.Urls.MO_TFA_GLOBAL_ADVANCED_SETTINGS.getUrl();
    }

    public Descriptor<MoGlobalAdvancedSettings> getDescriptor() {
        Jenkins jenkins = Jenkins.get();
        return jenkins.getDescriptorOrDie(this.getClass());
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doSaveAdvancedSettingsConfiguration(StaplerRequest request, StaplerResponse response) throws ServletException, IOException {
        try {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            JSONObject json = request.getSubmittedForm();
            MoGlobalConfig moGlobalConfig = MoGlobalConfig.get();
            moGlobalConfig.configure(request, json);
        }
        catch (Exception e) {
            LOGGER.fine("Error while submitting global configurations, error: " + e.getMessage());
        }
        FormApply.success((String)"./").generateResponse(request, response, null);
    }

    public String getCustomOTPEmailSubject() {
        String subject = null;
        if (this.moAdvanceSettingsDto != null) {
            subject = this.moAdvanceSettingsDto.getCustomOTPEmailSubject();
        }
        if (StringUtils.isBlank(subject)) {
            subject = MoGlobalConfigConstant.AdvanceSettingsConstants.DEFAULT_OTP_EMAIL_SUBJECT.getValue();
        }
        return subject;
    }

    public String getCustomOTPEmailTemplate() {
        String template = null;
        if (this.moAdvanceSettingsDto != null) {
            template = this.moAdvanceSettingsDto.getCustomOTPEmailTemplate();
        }
        if (StringUtils.isBlank(template)) {
            template = MoGlobalConfigConstant.AdvanceSettingsConstants.DEFAULT_OTP_EMAIL_TEMPLATE.getValue();
        }
        return template;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<MoGlobalAdvancedSettings> {
        @POST
        public FormValidation doCheckSkipTfaForApi(@QueryParameter Boolean skipTfaForApi) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return FormValidation.warning((String)"Available in premium version");
        }

        @POST
        public FormValidation doCheckEnableTfaOnBuild(@QueryParameter Boolean enableTfaOnBuild) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return FormValidation.warning((String)"Available in premium version");
        }

        @POST
        public FormValidation doCheckEnableRememberMe(@QueryParameter Boolean enableRememberMe) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return FormValidation.warning((String)"Available in premium version");
        }

        @POST
        public FormValidation doCheckEnforceRestApi2fa(@QueryParameter Boolean enforceRestApi2fa) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return FormValidation.warning((String)"Available in premium version");
        }

        @POST
        public FormValidation doCheckDuoAutoPushForRestApi(@QueryParameter Boolean duoAutoPushForRestApi) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return FormValidation.warning((String)"Available in premium version");
        }

        @POST
        public FormValidation doCheckSkipRestApi2faForTokens(@QueryParameter Boolean skipRestApi2faForTokens) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return FormValidation.warning((String)"Available in premium version");
        }

        public ListBoxModel doFillRememberMeTimeUnitItems() {
            return new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option("Minutes", "minutes"), new ListBoxModel.Option("Hours", "hours"), new ListBoxModel.Option("Days", "days")});
        }
    }
}

