/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.twofactor.jenkins;

import hudson.Extension;
import hudson.init.Initializer;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.util.PluginServletFilter;
import io.jenkins.plugins.twofactor.constants.MoGlobalConfigConstant;
import io.jenkins.plugins.twofactor.constants.MoPluginUrls;
import io.jenkins.plugins.twofactor.jenkins.MoGlobalConfig;
import io.jenkins.plugins.twofactor.jenkins.tfaMethodsConfig.MoOtpOverEmailConfig;
import io.jenkins.plugins.twofactor.jenkins.tfaMethodsConfig.MoSecurityQuestionConfig;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jenkins.model.Jenkins;

@Extension
public class MoFilter
implements Filter {
    public static final Map<String, Boolean> userAuthenticationStatus = new ConcurrentHashMap<String, Boolean>();
    public static final Map<String, Boolean> moPluginSettings = new ConcurrentHashMap<String, Boolean>();
    private static final Logger LOGGER = Logger.getLogger(MoFilter.class.getName());

    public void init(FilterConfig filterConfig) {
        try {
            moPluginSettings.put(MoGlobalConfigConstant.AdminConfiguration.ENABLE_2FA_FOR_ALL_USERS.getKey(), MoGlobalConfig.get().getEnableTfa());
        }
        catch (Exception e) {
            LOGGER.fine("Exception while initializing filter for global TFA authentication, error is " + e.getMessage());
        }
    }

    @Initializer
    public static void setUpFilter() throws ServletException {
        LOGGER.fine("Setting up the filter for the two-factor plugin");
        PluginServletFilter.addFilter((Filter)new MoFilter());
    }

    private String getRedirectUrlForTfaAuthentication(User user) {
        LOGGER.fine(" Calculating redirection url for 2FA authentication");
        Object redirectUrl = null;
        int totalConfiguredMethods = 0;
        int totalEnabledMethods = 0;
        for (UserProperty property : user.getAllProperties()) {
            switch (property.getClass().getSimpleName()) {
                case "MoSecurityQuestionConfig": {
                    if (!MoGlobalConfig.get().isEnableSecurityQuestionsAuthentication().booleanValue()) break;
                    ++totalEnabledMethods;
                    if (!((MoSecurityQuestionConfig)property).isConfigured()) break;
                    redirectUrl = MoPluginUrls.Urls.MO_USER_AUTH.getUrl() + "/" + MoPluginUrls.Urls.MO_SECURITY_QUESTION_AUTH.getUrl() + "/";
                    ++totalConfiguredMethods;
                    break;
                }
                case "MoOtpOverEmailConfig": {
                    if (!MoGlobalConfig.get().isEnableOtpOverEmailAuthentication().booleanValue()) break;
                    ++totalEnabledMethods;
                    if (!((MoOtpOverEmailConfig)property).isConfigured().booleanValue()) break;
                    redirectUrl = MoPluginUrls.Urls.MO_USER_AUTH.getUrl() + "/" + MoPluginUrls.Urls.MO_OTP_OVER_EMAIL_AUTH.getUrl() + "/";
                    ++totalConfiguredMethods;
                    break;
                }
            }
        }
        if (totalEnabledMethods != 0 && totalConfiguredMethods == 0) {
            LOGGER.fine("User has not configured any authentication method, redirecting to user configuration");
            redirectUrl = "user/" + user.getId() + "/" + MoPluginUrls.Urls.MO_USER_CONFIG.getUrl() + "/";
        } else if (totalEnabledMethods != 0 && totalConfiguredMethods > 1) {
            LOGGER.fine("User has configured multiple authentication methods, redirecting to user authentication");
            redirectUrl = MoPluginUrls.Urls.MO_USER_AUTH.getUrl() + "/";
        } else if (totalEnabledMethods == 0) {
            LOGGER.fine("Admin has not enabled any authentication methods, terminating 2FA");
            redirectUrl = "SKIP_FILTER";
        }
        LOGGER.fine("Redirecting to url " + redirectUrl);
        return redirectUrl;
    }

    private String sanitizeRequestURI(String requestURI) {
        requestURI = requestURI.trim();
        return requestURI;
    }

    private boolean urlsToAvoidRedirect(String url, List<String> urlsToCheck) {
        for (String avoidUrl : urlsToCheck) {
            if (!url.contains(avoidUrl)) continue;
            return true;
        }
        return false;
    }

    private boolean JenkinsUrlsToAvoidRedirect(String url) {
        List<String> jenkinsUrls = Arrays.asList("/logout", "/login", "/adjuncts", "/static", ".css", ".js", "PopupContent", "/ajaxBuildQueue", "/ajaxExecutors", "/descriptorByName", "/checkPluginUrl", "/log", "/theme-dark", "/resourceBundle", "/favicon.ico");
        return this.urlsToAvoidRedirect(url, jenkinsUrls);
    }

    private boolean tfaPluginUrlsToAvoidRedirect(String url) {
        List<String> tfaPluginUrls = Arrays.asList(MoPluginUrls.Urls.MO_USER_CONFIG.getUrl() + "/", MoPluginUrls.Urls.MO_SECURITY_QUESTION_CONFIG.getUrl(), "/miniorange-two-factor", MoPluginUrls.Urls.MO_OTP_OVER_EMAIL_CONFIG.getUrl(), MoPluginUrls.Urls.MO_USER_AUTH.getUrl() + "/");
        return this.urlsToAvoidRedirect(url, tfaPluginUrls);
    }

    private boolean RestUrlsToAvoid(String url) {
        List<String> restUrls = Arrays.asList("/createItem", "/createView", "/queue", "/overallLoad", "/quietDown", "/cancelQuietDown", "/restart", "/safeRestart", "/api/json");
        return this.urlsToAvoidRedirect(url, restUrls);
    }

    private static boolean enableTfaForAllUsers() {
        return moPluginSettings.getOrDefault(MoGlobalConfigConstant.AdminConfiguration.ENABLE_2FA_FOR_ALL_USERS.getKey(), false);
    }

    static boolean isTfaEnabled() {
        boolean enableForAllUsers = MoFilter.enableTfaForAllUsers();
        return !enableForAllUsers;
    }

    private boolean isTfaVerifiedSession(HttpSession session, User user) {
        try {
            String sessionAttributeKey = user.getId() + MoGlobalConfigConstant.UtilityGlobalConstants.SESSION_2FA_VERIFICATION.getKey();
            Object tfaVerificationAttribute = session.getAttribute(sessionAttributeKey);
            if (tfaVerificationAttribute != null) {
                boolean isTfaVerifiedSession = Boolean.parseBoolean(tfaVerificationAttribute.toString());
                userAuthenticationStatus.put(user.getId(), isTfaVerifiedSession);
                return isTfaVerifiedSession;
            }
            userAuthenticationStatus.put(user.getId(), false);
            return false;
        }
        catch (Exception e) {
            String errorMessage = "An error occurred while fetching session: " + e.getMessage();
            LOGGER.fine(errorMessage);
            return false;
        }
    }

    private boolean byPass2FA(User user, String url, HttpSession session) {
        if (user == null) {
            return true;
        }
        if (this.isTfaVerifiedSession(session, user)) {
            return true;
        }
        if (MoFilter.isTfaEnabled()) {
            return true;
        }
        return this.tfaPluginUrlsToAvoidRedirect(url) || this.JenkinsUrlsToAvoidRedirect(url) || this.RestUrlsToAvoid(url);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        try {
            HttpServletRequest req = (HttpServletRequest)servletRequest;
            User user = User.current();
            HttpSession session = req.getSession();
            if (this.byPass2FA(user, req.getPathInfo(), session)) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            String redirectUrl = this.getRedirectUrlForTfaAuthentication(user);
            LOGGER.fine("Authentication method url " + redirectUrl);
            if (redirectUrl.equals("SKIP_FILTER")) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            HttpServletResponse rsp = (HttpServletResponse)servletResponse;
            String relayState = req.getRequestURI();
            if (session.getAttribute("tfaRelayState") == null) {
                session.setAttribute("tfaRelayState", (Object)this.sanitizeRequestURI(relayState));
            }
            LOGGER.fine(req.getRequestURI() + " is being redirecting for 2FA, saved relay state is " + relayState);
            rsp.sendRedirect(Jenkins.get().getRootUrl() + redirectUrl);
        }
        catch (Exception e) {
            filterChain.doFilter(servletRequest, servletResponse);
            LOGGER.fine("Error in filter processing " + e.getMessage());
        }
    }

    public void destroy() {
    }
}

