/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mcp.server.extensions.util;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;

public class SlidingWindow<E> {
    private final int maxSize;
    private final Deque<E> deque;

    public SlidingWindow(int maxSize) {
        this.maxSize = maxSize;
        this.deque = new ArrayDeque(maxSize);
    }

    public boolean add(E e) {
        if (this.maxSize == 0) {
            return false;
        }
        boolean removed = false;
        if (this.deque.size() == this.maxSize) {
            removed = true;
            this.deque.removeFirst();
        }
        this.deque.addLast(e);
        return removed;
    }

    public E remove() {
        return this.deque.removeFirst();
    }

    public int size() {
        return this.deque.size();
    }

    public Collection<E> getRecords() {
        return this.deque;
    }

    public boolean isEmpty() {
        return this.deque.isEmpty();
    }

    public String toString() {
        return this.deque.toString();
    }
}

