/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.levo.helpers;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import hudson.util.Secret;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.jenkinsci.plugins.docker.commons.tools.DockerTool;

public class LevoDockerTool {
    public static final int CLIENT_TIMEOUT = 1800;
    public static final int PULL_TIMEOUT = 300;
    public static final int CMD_TIMEOUT = 60;
    public static final String ENV_FILE_NAME = "environment.yaml";
    public static final String LEVO_CONFIG_FOLDER_NAME = ".levoconfig";
    public static final String LEVO_REPORTS_FOLDER_NAME = "levo-reports";

    private static String runAndParseOutput(Launcher launcher, EnvVars envVars, ArgumentListBuilder cmd) throws IOException, InterruptedException {
        return LevoDockerTool.runAndParseOutput(launcher, envVars, cmd, 60);
    }

    private static String runAndParseOutput(Launcher launcher, EnvVars envVars, ArgumentListBuilder cmd, int timeout) throws IOException, InterruptedException {
        Launcher.ProcStarter procStarter = launcher.launch();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        procStarter.quiet(false).cmds(cmd).envs((Map)envVars).stdout((OutputStream)baos).start().joinWithTimeout((long)timeout, TimeUnit.SECONDS, launcher.getListener());
        return baos.toString(StandardCharsets.UTF_8.name()).trim();
    }

    private static String getUserId(Launcher launcher, EnvVars launchEnv) throws IOException, InterruptedException {
        ArgumentListBuilder argb = new ArgumentListBuilder();
        argb.add(new String[]{"id", "-u"});
        return LevoDockerTool.runAndParseOutput(launcher, launchEnv, argb);
    }

    private static String getUserGroupId(Launcher launcher, EnvVars launchEnv) throws IOException, InterruptedException {
        ArgumentListBuilder argb = new ArgumentListBuilder();
        argb.add(new String[]{"id", "-g"});
        return LevoDockerTool.runAndParseOutput(launcher, launchEnv, argb);
    }

    private static ArgumentListBuilder buildLevoCommand(@NonNull Run run, @NonNull Launcher launcher, @NonNull EnvVars launchEnv, @Nullable EnvVars buildEnv, String workdir, @Nullable String baseUrl) throws IOException, InterruptedException {
        Object osName;
        Path levoReportsPath;
        Node currentNode = Optional.of(run).map(Run::getExecutor).map(Executor::getOwner).map(Computer::getNode).orElse(null);
        if (currentNode == null) {
            throw new IllegalStateException("Run has no executor");
        }
        ArgumentListBuilder argb = new ArgumentListBuilder();
        argb.add(new String[]{DockerTool.getExecutable(null, (Node)currentNode, (TaskListener)launcher.getListener(), (EnvVars)launchEnv), "run"});
        Path levoConfigPath = Paths.get(workdir, LEVO_CONFIG_FOLDER_NAME);
        if (!Files.exists(levoConfigPath, new LinkOption[0])) {
            Files.createDirectory(levoConfigPath, new FileAttribute[0]);
        }
        if (!Files.exists(levoReportsPath = Paths.get(workdir, LEVO_REPORTS_FOLDER_NAME), new LinkOption[0])) {
            Files.createDirectory(levoReportsPath, new FileAttribute[0]);
        }
        argb.add(new String[]{"-v", String.valueOf(levoConfigPath) + ":/home/levo/.config/configstore:rw"});
        argb.add(new String[]{"-v", String.valueOf(levoReportsPath) + ":/home/levo/reports:rw"});
        argb.add(new String[]{"-v", workdir + ":/home/levo/work:rw"});
        Computer computer = Optional.of(currentNode).map(Node::toComputer).orElse(null);
        Map systemProperties = null;
        if (computer != null) {
            systemProperties = computer.getSystemProperties();
        }
        if (systemProperties != null && (osName = systemProperties.get("os.name")) instanceof String && ((String)osName).toLowerCase().contains("linux")) {
            argb.add(new String[]{"-e", "LOCAL_USER_ID=" + LevoDockerTool.getUserId(launcher, launchEnv)});
            argb.add(new String[]{"-e", "LOCAL_GROUP_ID=" + LevoDockerTool.getUserGroupId(launcher, launchEnv)});
        }
        argb.add(new String[]{"-e", "TERM=xterm-256color"});
        String apiBaseUrl = baseUrl != null && !baseUrl.trim().isEmpty() ? baseUrl : "https://api.levo.ai";
        argb.add(new String[]{"-e", "LEVO_BASE_URL=" + apiBaseUrl});
        argb.add("levoai/levo:stable");
        return argb;
    }

    private static void runDockerPull(@NonNull Run run, @NonNull Launcher launcher, @NonNull EnvVars launchEnv) throws IOException, InterruptedException {
        Node currentNode = Optional.of(run).map(Run::getExecutor).map(Executor::getOwner).map(Computer::getNode).orElse(null);
        if (currentNode == null) {
            throw new IllegalStateException("Run has no executor");
        }
        ArgumentListBuilder argb = new ArgumentListBuilder();
        argb.add(new String[]{DockerTool.getExecutable(null, (Node)currentNode, (TaskListener)launcher.getListener(), (EnvVars)launchEnv), "pull"});
        argb.add("levoai/levo:stable");
        LevoDockerTool.runAndParseOutput(launcher, launchEnv, argb, 300);
    }

    public static void runLevoLogin(@NonNull Run run, @NonNull Launcher launcher, @NonNull EnvVars launchEnv, String workdir, Secret authorizationKey, String organizationId, @Nullable String baseUrl) throws IOException, InterruptedException {
        if (authorizationKey == null || authorizationKey.getPlainText() == null || authorizationKey.getPlainText().trim().isEmpty()) {
            throw new IllegalArgumentException("Authorization key is missing or empty");
        }
        if (organizationId == null || organizationId.trim().isEmpty()) {
            throw new IllegalArgumentException("Organization ID is missing or empty");
        }
        LevoDockerTool.cleanupCredentials(run, launcher, launchEnv, workdir, baseUrl, launcher.getListener());
        launcher.getListener().getLogger().println("Pulling latest Levo CLI image...");
        LevoDockerTool.runDockerPull(run, launcher, launchEnv);
        String apiKey = authorizationKey.getPlainText();
        String maskedKey = apiKey.length() > 6 ? apiKey.substring(0, 3) + "..." + apiKey.substring(apiKey.length() - 3) : "***";
        ArgumentListBuilder argb = LevoDockerTool.buildLevoCommand(run, launcher, launchEnv, null, workdir, baseUrl);
        argb.add(new String[]{"login", "-k", apiKey, "-o", organizationId});
        launcher.getListener().getLogger().println("Starting launch for: docker run ... login -k " + maskedKey + " -o " + organizationId);
        Launcher.ProcStarter procStarter = launcher.launch();
        int exitCode = procStarter.quiet(false).cmds(argb).envs((Map)launchEnv).stdout((OutputStream)launcher.getListener().getLogger()).stderr((OutputStream)launcher.getListener().getLogger()).start().joinWithTimeout(1800L, TimeUnit.SECONDS, launcher.getListener());
        if (exitCode != 0) {
            throw new IOException("Levo login failed with exit code: " + exitCode + ". Please verify your API key and organization ID are correct.");
        }
    }

    public static void runLevoConformanceTest(@NonNull Run run, @NonNull Launcher launcher, @NonNull EnvVars launchEnv, @Nullable EnvVars buildEnv, String workdir, String target, String schema) throws IOException, InterruptedException {
        ArgumentListBuilder argb = LevoDockerTool.buildLevoCommand(run, launcher, launchEnv, buildEnv, workdir, null);
        argb.add(new String[]{"test-conformance", "--target-url", target, "--schema", schema});
        launcher.getListener().getLogger().println("Starting launch for: " + argb.toString());
        Launcher.ProcStarter procStarter = launcher.launch();
        try {
            procStarter.quiet(false).cmds(argb).envs((Map)launchEnv).stdout((OutputStream)launcher.getListener().getLogger()).stderr((OutputStream)launcher.getListener().getLogger()).start().joinWithTimeout(1800L, TimeUnit.SECONDS, launcher.getListener());
            LevoDockerTool.afterRunCleanUp(run, launcher, launchEnv, workdir, null, launcher.getListener());
        }
        catch (InterruptedException e) {
            LevoDockerTool.afterRunCleanUp(run, launcher, launchEnv, workdir, null, launcher.getListener());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runLevoTestPlan(@NonNull Run run, @NonNull Launcher launcher, @NonNull EnvVars launchEnv, @Nullable EnvVars buildEnv, String workdir, String target, String testPlan, @Nullable String appName, @Nullable String env, @Nullable String categories, @Nullable String dataSource, @Nullable String testUsers, @Nullable String environment, Boolean generateJUnitReports, String extraCLIArgs, @Nullable String organizationId, @Nullable String baseUrl) throws IOException, InterruptedException {
        LevoDockerTool.runDockerPull(run, launcher, launchEnv);
        ArgumentListBuilder argb = LevoDockerTool.buildLevoCommand(run, launcher, launchEnv, buildEnv, workdir, baseUrl);
        argb.add("test");
        if (organizationId != null && !organizationId.trim().isEmpty()) {
            argb.add(new String[]{"--organization", organizationId});
        }
        if (appName != null && !appName.trim().isEmpty()) {
            if (testPlan != null && !testPlan.trim().isEmpty()) {
                throw new IllegalArgumentException("--app-name cannot be used with --test-plan");
            }
            argb.add(new String[]{"--app-name", appName});
            if (env == null || env.trim().isEmpty()) {
                throw new IllegalArgumentException("--env is required when using --app-name");
            }
            argb.add(new String[]{"--env", env});
            if (categories != null && !categories.trim().isEmpty()) {
                argb.add(new String[]{"--categories", categories});
            }
            if (dataSource != null && !dataSource.trim().isEmpty()) {
                argb.add(new String[]{"--data-source", dataSource});
            }
            if (testUsers != null && !testUsers.trim().isEmpty()) {
                argb.add(new String[]{"--test-users", testUsers});
            }
        } else if (testPlan != null && !testPlan.trim().isEmpty()) {
            argb.add(new String[]{"--test-plan", testPlan});
        } else {
            throw new IllegalArgumentException("One of --test-plan or --app-name must be provided");
        }
        if (target != null && !target.trim().isEmpty()) {
            argb.add(new String[]{"--target-url", target});
        } else if (testPlan != null && !testPlan.trim().isEmpty()) {
            throw new IllegalArgumentException("--target-url is required when using --test-plan");
        }
        if (generateJUnitReports != null && generateJUnitReports.booleanValue()) {
            argb.add("--export-junit-xml=/home/levo/reports/junit.xml");
        }
        if (environment != null) {
            Path envPath = Paths.get(workdir, ENV_FILE_NAME);
            if (Files.exists(envPath, new LinkOption[0])) {
                Files.delete(envPath);
            }
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(envPath.toString()), StandardCharsets.UTF_8));){
                writer.append(environment);
                argb.add(new String[]{"--env-file", ENV_FILE_NAME});
            }
        }
        if (extraCLIArgs != null && !extraCLIArgs.isEmpty()) {
            argb.addTokenized(extraCLIArgs);
        }
        launcher.getListener().getLogger().println("Starting launch for: " + argb.toString());
        Launcher.ProcStarter procStarter = launcher.launch();
        try {
            procStarter.quiet(false).cmds(argb).envs((Map)launchEnv).stdout((OutputStream)launcher.getListener().getLogger()).stderr((OutputStream)launcher.getListener().getLogger()).start().joinWithTimeout(1800L, TimeUnit.SECONDS, launcher.getListener());
        }
        finally {
            LevoDockerTool.afterRunCleanUp(run, launcher, launchEnv, workdir, baseUrl, launcher.getListener());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runLevoRemoteTestRun(@NonNull Run run, @NonNull Launcher launcher, @NonNull EnvVars launchEnv, @Nullable EnvVars buildEnv, String workdir, String appName, String environment, String categories, String httpMethods, String excludeMethods, String endpointPattern, String excludeEndpointPattern, String testUsers, String targetUrl, String dataSource, String runOn, String failSeverity, String failScope, String failThreshold, Secret authorizationKey, String organizationId, @Nullable String baseUrl) throws IOException, InterruptedException {
        LevoDockerTool.runDockerPull(run, launcher, launchEnv);
        ArgumentListBuilder argb = LevoDockerTool.buildLevoCommand(run, launcher, launchEnv, buildEnv, workdir, baseUrl);
        argb.add("remote-test-run");
        if (appName != null && !appName.trim().isEmpty()) {
            argb.add(new String[]{"--app-name", appName});
        }
        if (environment != null && !environment.trim().isEmpty()) {
            argb.add(new String[]{"--env", environment});
        }
        if (dataSource == null || dataSource.trim().isEmpty()) {
            throw new IllegalArgumentException("--data-source is required");
        }
        argb.add(new String[]{"--data-source", dataSource.trim()});
        if (runOn == null || runOn.trim().isEmpty()) {
            throw new IllegalArgumentException("--run-on is required");
        }
        String normalizedRunOn = runOn.trim().toLowerCase();
        if ("onprem".equalsIgnoreCase(normalizedRunOn) || "on-premises".equalsIgnoreCase(normalizedRunOn)) {
            normalizedRunOn = "on-prem";
        }
        argb.add(new String[]{"--run-on", normalizedRunOn});
        if (categories != null && !categories.trim().isEmpty()) {
            argb.add(new String[]{"--categories", categories});
        }
        if (httpMethods != null && !httpMethods.trim().isEmpty()) {
            argb.add(new String[]{"--methods", httpMethods});
        }
        if (excludeMethods != null && !excludeMethods.trim().isEmpty()) {
            argb.add(new String[]{"--exclude-methods", excludeMethods});
        }
        if (endpointPattern != null && !endpointPattern.trim().isEmpty()) {
            argb.add(new String[]{"--endpoint-pattern", endpointPattern});
        }
        if (excludeEndpointPattern != null && !excludeEndpointPattern.trim().isEmpty()) {
            argb.add(new String[]{"--exclude-endpoint-pattern", excludeEndpointPattern});
        }
        if (testUsers != null && !testUsers.trim().isEmpty()) {
            argb.add(new String[]{"--test-users", testUsers});
        }
        if (targetUrl == null || targetUrl.trim().isEmpty()) {
            throw new IllegalArgumentException("--target-url is required for remote-test-run");
        }
        argb.add(new String[]{"--target-url", targetUrl});
        if (failSeverity != null && !failSeverity.trim().isEmpty() && !"none".equals(failSeverity)) {
            argb.add(new String[]{"--fail-severity", failSeverity});
        }
        if (failScope != null && !failScope.trim().isEmpty() && !"none".equals(failScope)) {
            argb.add(new String[]{"--fail-scope", failScope});
        }
        if (failThreshold != null && !failThreshold.trim().isEmpty()) {
            argb.add(new String[]{"--fail-threshold", failThreshold});
        }
        argb.add(new String[]{"--key", authorizationKey.getPlainText()});
        argb.add(new String[]{"--organization", organizationId});
        argb.add(new String[]{"--verbosity", "INFO"});
        launcher.getListener().getLogger().println("Starting remote test run: " + argb.toString());
        Launcher.ProcStarter procStarter = launcher.launch();
        try {
            procStarter.quiet(false).cmds(argb).envs((Map)launchEnv).stdout((OutputStream)launcher.getListener().getLogger()).stderr((OutputStream)launcher.getListener().getLogger()).start().joinWithTimeout(1800L, TimeUnit.SECONDS, launcher.getListener());
        }
        finally {
            LevoDockerTool.afterRunCleanUp(run, launcher, launchEnv, workdir, baseUrl, launcher.getListener());
        }
    }

    private static void cleanupCredentials(@NonNull Run run, @NonNull Launcher launcher, @NonNull EnvVars launchEnv, String workdir, @Nullable String baseUrl, TaskListener listener) throws IOException, InterruptedException {
        try {
            Launcher.ProcStarter procStarter;
            int exitCode;
            ArgumentListBuilder argb = LevoDockerTool.buildLevoCommand(run, launcher, launchEnv, null, workdir, baseUrl);
            argb.add("logout");
            if (listener != null) {
                listener.getLogger().println("Cleaning up credentials using levo logout...");
            }
            if ((exitCode = (procStarter = launcher.launch()).quiet(false).cmds(argb).envs((Map)launchEnv).stdout((OutputStream)(listener != null ? listener.getLogger() : System.out)).stderr((OutputStream)(listener != null ? listener.getLogger() : System.err)).start().joinWithTimeout(60L, TimeUnit.SECONDS, listener)) != 0 && listener != null) {
                listener.getLogger().println("Note: logout command exited with code " + exitCode + " (this is expected if no credentials exist)");
            }
        }
        catch (IOException | InterruptedException e) {
            if (listener != null) {
                listener.getLogger().println("Warning: Could not run levo logout: " + e.getMessage());
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    private static void afterRunCleanUp(@NonNull Run run, @NonNull Launcher launcher, @NonNull EnvVars launchEnv, String workdir, @Nullable String baseUrl, TaskListener listener) throws IOException, InterruptedException {
        Path envPath = Paths.get(workdir, ENV_FILE_NAME);
        if (Files.exists(envPath, new LinkOption[0])) {
            Files.delete(envPath);
        }
        try {
            ArgumentListBuilder argb = LevoDockerTool.buildLevoCommand(run, launcher, launchEnv, null, workdir, baseUrl);
            argb.add("logout");
            Launcher.ProcStarter procStarter = launcher.launch();
            procStarter.quiet(true).cmds(argb).envs((Map)launchEnv).start().joinWithTimeout(60L, TimeUnit.SECONDS, listener);
        }
        catch (IOException | InterruptedException e) {
            if (listener != null) {
                listener.getLogger().println("Note: Could not run levo logout during cleanup: " + e.getMessage());
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
    }
}

