/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.kubernetes.ephemeral;

import edu.umd.cs.findbugs.annotations.NonNull;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
class EphemeralContainerMonitor {
    private static final int FILE_MONITOR_POLL_SECS = Integer.getInteger(EphemeralContainerMonitor.class.getName() + ".fileMonitorPollSecs", 1);

    EphemeralContainerMonitor() {
    }

    static String[] containerWaitCommand(String containerName) {
        return new String[]{"sh", "-c", EphemeralContainerMonitor.fileMonitorScript(containerName)};
    }

    static String[] containerStopCommand(String containerName) {
        return new String[]{"touch", EphemeralContainerMonitor.fileMonitorPath(containerName)};
    }

    private static String fileMonitorScript(@NonNull String containerName) {
        int pollSecs = Math.max(1, FILE_MONITOR_POLL_SECS);
        String fileMonPath = EphemeralContainerMonitor.fileMonitorPath(containerName);
        return "set -e; { while ! test -f '" + fileMonPath + "' ; do sleep " + pollSecs + "; done }";
    }

    private static String fileMonitorPath(String containerName) {
        return "/tmp/" + containerName + "-jenkins-step-is-done-monitor";
    }
}

