/*
 * Decompiled with CFR 0.152.
 */
package org.aerogear.kryptowire;

import hudson.FilePath;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.aerogear.kryptowire.KryptowireService;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONArray;
import org.json.JSONObject;

public class KryptowireServiceImpl
implements KryptowireService {
    private static final Logger logger = Logger.getLogger(KryptowireServiceImpl.class.getName());
    private String apiKey;
    private String apiEndpoint;
    private HttpClient httpclient;

    public KryptowireServiceImpl(String apiEndpoint, String apiKey, HttpClient httpclient) {
        this.apiEndpoint = apiEndpoint;
        this.apiKey = apiKey;
        this.httpclient = httpclient;
        if (this.apiEndpoint != null && !this.apiEndpoint.isEmpty() && !this.apiEndpoint.endsWith("/")) {
            this.apiEndpoint = this.apiEndpoint + "/";
        }
    }

    public KryptowireServiceImpl(String apiEndpoint, String apiKey) {
        this(apiEndpoint, apiKey, (HttpClient)HttpClients.createDefault());
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiEndpoint() {
        return this.apiEndpoint;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setApiEndpoint(String apiEndpoint) {
        this.apiEndpoint = apiEndpoint;
    }

    @Override
    public JSONObject submit(String platform, FilePath filePath) throws IOException, InterruptedException {
        String endPointUrl = this.getApiEndpoint() + "/api/submit";
        HttpPost post = new HttpPost(endPointUrl);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addBinaryBody("app", filePath.read(), ContentType.APPLICATION_OCTET_STREAM, filePath.getName());
        builder.addTextBody("key", this.getApiKey());
        builder.addTextBody("platform", platform);
        HttpEntity entity = builder.build();
        post.setEntity(entity);
        BasicResponseHandler handler = new BasicResponseHandler();
        String responseBody = (String)this.httpclient.execute((HttpUriRequest)post, (ResponseHandler)handler);
        return new JSONObject(responseBody);
    }

    @Override
    public KryptowireService.AnalysisStatus getStatus(String hash) throws IOException, InterruptedException {
        BasicResponseHandler handler;
        String endPointUrl = this.getApiEndpoint() + "/api/status?key=" + this.getApiKey() + "&hash=" + hash;
        HttpGet get = new HttpGet(endPointUrl);
        String responseBody = (String)this.httpclient.execute((HttpUriRequest)get, (ResponseHandler)(handler = new BasicResponseHandler()));
        JSONObject res = new JSONObject(responseBody);
        String status = res.getString("status");
        if (status.equals("processing")) {
            return KryptowireService.AnalysisStatus.PROCESSING;
        }
        if (status.equals("not_submitted")) {
            return KryptowireService.AnalysisStatus.NOT_SUBMITTED;
        }
        return KryptowireService.AnalysisStatus.COMPLETE;
    }

    @Override
    public JSONObject getResult(String uuid) throws IOException, InterruptedException {
        String endPointUrl = this.getApiEndpoint() + "/api/submitted-apps?key=" + this.getApiKey();
        HttpGet get = new HttpGet(endPointUrl);
        BasicResponseHandler handler = new BasicResponseHandler();
        String responseBody = (String)this.httpclient.execute((HttpUriRequest)get, (ResponseHandler)handler);
        JSONArray arr = new JSONArray(responseBody);
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject item = arr.getJSONObject(i);
            if (item.isNull("uuid") || !item.getString("uuid").equals(uuid)) continue;
            return item;
        }
        return new JSONObject("{}");
    }

    @Override
    public void downloadReport(String hash, String type, File targetFile) throws IOException, InterruptedException {
        String endPointUrl = this.getApiEndpoint() + "/api/results/" + type + "?key=" + this.getApiKey() + "&hash=" + hash;
        HttpGet get = new HttpGet(endPointUrl);
        HttpResponse response = this.httpclient.execute((HttpUriRequest)get);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() >= 300) {
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            FileUtils.copyInputStreamToFile((InputStream)entity.getContent(), (File)targetFile);
        }
    }

    @Override
    public boolean isCompleted(String hash) throws IOException, InterruptedException {
        return this.getStatus(hash) == KryptowireService.AnalysisStatus.COMPLETE;
    }
}

