/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jfrog.configuration;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.jfrog.configuration.JFrogPlatformInstance;
import io.jenkins.plugins.jfrog.plugins.PluginsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;

public class JFrogPlatformBuilder
extends GlobalConfiguration {
    private static final String[] KNOWN_PROTOCOLS = new String[]{"http://", "https://", "ssh://"};
    private static final String UNSAFE_HTTP_ERROR = "HTTP (non HTTPS) connections to the JFrog platform services are not allowed. To bypass this rule, check 'Allow HTTP Connections'.";
    private static final String UNKNOWN_PROTOCOL_ERROR = "URL must start with one of the following protocols: " + Arrays.toString(KNOWN_PROTOCOLS);

    static boolean isUnsafe(boolean allowHttpConnections, String ... urls) {
        if (allowHttpConnections) {
            return false;
        }
        for (String url : urls) {
            if (!StringUtils.startsWith((CharSequence)url, (CharSequence)"http://")) continue;
            return true;
        }
        return false;
    }

    static boolean isInvalidProtocolOrEmptyUrl(String ... urls) {
        return Arrays.stream(urls).filter(StringUtils::isNotBlank).anyMatch(url -> !StringUtils.startsWithAny((CharSequence)url, (CharSequence[])KNOWN_PROTOCOLS));
    }

    public static List<JFrogPlatformInstance> getJFrogPlatformInstances() {
        DescriptorImpl descriptor = (DescriptorImpl)Hudson.get().getDescriptor(JFrogPlatformBuilder.class);
        if (descriptor == null) {
            return new ArrayList<JFrogPlatformInstance>();
        }
        return descriptor.getJfrogInstances();
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<GlobalConfiguration> {
        private List<JFrogPlatformInstance> jfrogInstances;
        private boolean allowHttpConnections;

        public DescriptorImpl() {
            super(JFrogPlatformBuilder.class);
            this.load();
        }

        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project) {
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins != null && jenkins.hasPermission(Jenkins.ADMINISTER)) {
                return PluginsUtils.fillPluginCredentials(project);
            }
            return new StandardListBoxModel();
        }

        @POST
        public FormValidation doCheckServerId(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (StringUtils.isBlank((CharSequence)value)) {
                return FormValidation.error((String)"Please set server ID");
            }
            List<JFrogPlatformInstance> JFrogPlatformInstances = JFrogPlatformBuilder.getJFrogPlatformInstances();
            if (JFrogPlatformInstances == null) {
                return FormValidation.ok();
            }
            int countServersByValueAsName = 0;
            for (JFrogPlatformInstance JFrogPlatformInstance2 : JFrogPlatformInstances) {
                if (!JFrogPlatformInstance2.getId().equals(value) || ++countServersByValueAsName <= 1) continue;
                return FormValidation.error((String)"Duplicated JFrog platform instances ID");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckUrl(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (StringUtils.isBlank((CharSequence)value)) {
                return FormValidation.error((String)"Please set the JFrog Platform URL");
            }
            return this.checkUrlInForm(value);
        }

        @POST
        public FormValidation doCheckArtifactoryUrl(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return this.checkUrlInForm(value);
        }

        @POST
        public FormValidation doCheckDistributionUrl(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return this.checkUrlInForm(value);
        }

        @POST
        public FormValidation doCheckXrayUrl(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return this.checkUrlInForm(value);
        }

        private FormValidation checkUrlInForm(String value) {
            if (JFrogPlatformBuilder.isInvalidProtocolOrEmptyUrl(value)) {
                return FormValidation.error((String)UNKNOWN_PROTOCOL_ERROR);
            }
            if (JFrogPlatformBuilder.isUnsafe(this.isAllowHttpConnections(), value)) {
                return FormValidation.error((String)JFrogPlatformBuilder.UNSAFE_HTTP_ERROR);
            }
            return FormValidation.ok();
        }

        public boolean configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            if (jenkins != null && jenkins.hasPermission(Jenkins.ADMINISTER)) {
                this.setAllowHttpConnections(o.getBoolean("allowHttpConnections"));
                this.configureJFrogInstances(req, o);
                this.save();
                return super.configure(req, o);
            }
            throw new Descriptor.FormException("User doesn't have permissions to save", "Server ID");
        }

        private void configureJFrogInstances(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            List<JFrogPlatformInstance> jfrogInstances = new ArrayList<JFrogPlatformInstance>();
            Object jfrogInstancesObj = o.get("jfrogInstances");
            if (!JSONNull.getInstance().equals(jfrogInstancesObj)) {
                jfrogInstances = req.bindJSONToList(JFrogPlatformInstance.class, jfrogInstancesObj);
            }
            if (!this.isJFrogInstancesIDConfigured(jfrogInstances)) {
                throw new Descriptor.FormException("Please set the Instance ID.", "ServerID");
            }
            if (this.isInstanceDuplicated(jfrogInstances)) {
                throw new Descriptor.FormException("The JFrog server ID you have entered is already configured", "Server ID");
            }
            if (this.isEmptyUrl(jfrogInstances)) {
                throw new Descriptor.FormException("Please set the JFrog Platform URL", "URL");
            }
            for (JFrogPlatformInstance jfrogInstance : jfrogInstances) {
                if (JFrogPlatformBuilder.isUnsafe(this.isAllowHttpConnections(), jfrogInstance.getUrl(), jfrogInstance.getArtifactoryUrl(), jfrogInstance.getDistributionUrl(), jfrogInstance.getXrayUrl())) {
                    throw new Descriptor.FormException(JFrogPlatformBuilder.UNSAFE_HTTP_ERROR, "URL");
                }
                if (!JFrogPlatformBuilder.isInvalidProtocolOrEmptyUrl(jfrogInstance.getUrl(), jfrogInstance.getArtifactoryUrl(), jfrogInstance.getDistributionUrl(), jfrogInstance.getXrayUrl())) continue;
                throw new Descriptor.FormException(UNKNOWN_PROTOCOL_ERROR, "URL");
            }
            this.setJfrogInstances(jfrogInstances);
        }

        private boolean isJFrogInstancesIDConfigured(List<JFrogPlatformInstance> jfrogInstances) {
            if (jfrogInstances == null) {
                return true;
            }
            for (JFrogPlatformInstance server : jfrogInstances) {
                String platformId = server.getId();
                if (!StringUtils.isBlank((CharSequence)platformId)) continue;
                return false;
            }
            return true;
        }

        private boolean isInstanceDuplicated(List<JFrogPlatformInstance> jfrogInstances) {
            HashSet<String> serversNames = new HashSet<String>();
            if (jfrogInstances == null) {
                return false;
            }
            for (JFrogPlatformInstance instance : jfrogInstances) {
                String id = instance.getId();
                if (serversNames.contains(id)) {
                    return true;
                }
                serversNames.add(id);
            }
            return false;
        }

        private boolean isEmptyUrl(List<JFrogPlatformInstance> jfrogInstances) {
            if (jfrogInstances == null) {
                return false;
            }
            for (JFrogPlatformInstance instance : jfrogInstances) {
                if (!StringUtils.isBlank((CharSequence)instance.getUrl())) continue;
                return true;
            }
            return false;
        }

        public List<JFrogPlatformInstance> getJfrogInstances() {
            return this.jfrogInstances;
        }

        public void setJfrogInstances(List<JFrogPlatformInstance> jfrogInstances) {
            this.jfrogInstances = jfrogInstances;
        }

        public boolean isAllowHttpConnections() {
            return this.allowHttpConnections;
        }

        public void setAllowHttpConnections(boolean allowHttpConnections) {
            this.allowHttpConnections = allowHttpConnections;
        }
    }
}

