/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jfrog;

import hudson.Extension;
import hudson.tools.ToolInstallation;
import hudson.util.FormValidation;
import io.jenkins.plugins.jfrog.ArtifactoryInstaller;
import io.jenkins.plugins.jfrog.BinaryInstaller;
import io.jenkins.plugins.jfrog.JfrogInstallation;
import io.jenkins.plugins.jfrog.configuration.Credentials;
import io.jenkins.plugins.jfrog.configuration.CredentialsConfig;
import io.jenkins.plugins.jfrog.configuration.JFrogPlatformInstance;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class ReleasesInstaller
extends ArtifactoryInstaller {
    private static final String RELEASES_ARTIFACTORY_URL = "https://releases.jfrog.io/artifactory";
    private static final String RELEASES_REPOSITORY = "jfrog-cli";

    @DataBoundConstructor
    public ReleasesInstaller() {
        super("", RELEASES_REPOSITORY, "");
    }

    @Override
    @DataBoundSetter
    public void setVersion(String version) {
        super.setVersion(version);
    }

    @Override
    public String getRepository() {
        return RELEASES_REPOSITORY;
    }

    @Override
    JFrogPlatformInstance getSpecificServer(String id) {
        CredentialsConfig emptyCred = new CredentialsConfig("", Credentials.EMPTY_CREDENTIALS);
        return new JFrogPlatformInstance("", "", emptyCred, RELEASES_ARTIFACTORY_URL, "", "");
    }

    @Extension
    public static final class DescriptorImpl
    extends BinaryInstaller.DescriptorImpl<ReleasesInstaller> {
        @Nonnull
        public String getDisplayName() {
            return "Install from releases.jfrog.io";
        }

        public boolean isApplicable(Class<? extends ToolInstallation> toolType) {
            return toolType == JfrogInstallation.class;
        }

        @POST
        public FormValidation doCheckVersion(@QueryParameter String version) {
            return ArtifactoryInstaller.validateCliVersion(version);
        }
    }
}

