/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jfrog.actions;

import hudson.EnvVars;
import hudson.model.Action;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;

public class JFrogCliConfigEncryption
implements Action {
    private boolean shouldEncrypt;
    private String keyOrPath;

    public JFrogCliConfigEncryption(EnvVars env) {
        if (env.containsKey((Object)"JFROG_CLI_HOME_DIR")) {
            return;
        }
        this.shouldEncrypt = true;
        String workspacePath = (String)env.get((Object)"WORKSPACE");
        if (workspacePath == null || workspacePath.isEmpty()) {
            workspacePath = System.getProperty("java.io.tmpdir");
        }
        Path encryptionDir = Paths.get(workspacePath, ".jfrog", "encryption");
        try {
            Files.createDirectories(encryptionDir, new FileAttribute[0]);
            String fileName = UUID.randomUUID().toString() + ".key";
            Path keyFilePath = encryptionDir.resolve(fileName);
            String encryptionKeyContent = UUID.randomUUID().toString().replaceAll("-", "");
            Files.write(keyFilePath, encryptionKeyContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            this.keyOrPath = keyFilePath.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getKey() {
        if (this.keyOrPath == null || this.keyOrPath.isEmpty()) {
            return null;
        }
        try {
            byte[] keyBytes = Files.readAllBytes(Paths.get(this.keyOrPath, new String[0]));
            return new String(keyBytes, StandardCharsets.UTF_8).trim();
        }
        catch (IOException e) {
            System.err.println("Error reading encryption key file: " + e.getMessage());
            return null;
        }
    }

    public String getKeyOrFilePath() {
        if (this.keyOrPath == null || this.keyOrPath.isEmpty()) {
            return null;
        }
        return this.keyOrPath;
    }

    public boolean shouldEncrypt() {
        return this.shouldEncrypt;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "JFrog CLI config encryption";
    }

    public String getUrlName() {
        return null;
    }
}

