/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.insightappsec.credentials;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import io.jenkins.plugins.insightappsec.credentials.InsightAPICredentials;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;

public class InsightCredentialsHelper {
    public List<InsightAPICredentials> lookupAllInsightCredentials(Jenkins context) {
        return CredentialsProvider.lookupCredentials(InsightAPICredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM, Collections.emptyList());
    }

    public InsightAPICredentials lookupInsightCredentialsById(String credentialsId) {
        InsightAPICredentials credentials = (InsightAPICredentials)CredentialsMatchers.firstOrNull(this.lookupAllInsightCredentials(Jenkins.getInstance()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        if (credentials == null) {
            throw new IllegalStateException(String.format("Insight credentials not found for ID %s", credentialsId));
        }
        return credentials;
    }
}

