/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.insightappsec.api.scan;

import io.jenkins.plugins.insightappsec.api.AbstractApi;
import io.jenkins.plugins.insightappsec.api.Identifiable;
import io.jenkins.plugins.insightappsec.api.scan.Scan;
import io.jenkins.plugins.insightappsec.api.scan.ScanAction;
import io.jenkins.plugins.insightappsec.api.scan.ScanExecutionDetails;
import org.apache.http.client.HttpClient;

public class ScanApi
extends AbstractApi {
    private static final String SCANS = "/scans";
    private static final String EXECUTION_DETAILS = "/execution-details";
    private static final String ACTION = "/action";

    public ScanApi(HttpClient client, String host, String apiKey) {
        super(client, host, apiKey);
    }

    public String submitScan(String scanConfigId) {
        return this.post(SCANS, new Scan(new Identifiable(scanConfigId), null));
    }

    public Scan getScan(String scanId) {
        return this.getById("/scans/" + scanId, scanId, Scan.class);
    }

    public ScanExecutionDetails getScanExecutionDetails(String scanId) {
        return this.getById("/scans/" + scanId + EXECUTION_DETAILS, scanId, ScanExecutionDetails.class);
    }

    public void submitScanAction(String scanId, ScanAction scanAction) {
        this.put("/scans/" + scanId + ACTION, scanAction);
    }
}

