/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.insightappsec;

import hudson.model.Action;
import hudson.model.Run;
import io.jenkins.plugins.insightappsec.BuildAdvanceIndicator;
import io.jenkins.plugins.insightappsec.InsightAppSecLogger;
import io.jenkins.plugins.insightappsec.InsightAppSecScanStepAction;
import io.jenkins.plugins.insightappsec.ScanResults;
import io.jenkins.plugins.insightappsec.exception.VulnerabilitySearchException;
import org.apache.commons.collections.CollectionUtils;

public class ScanResultHandler {
    public void handleScanResults(Run<?, ?> run, InsightAppSecLogger logger, BuildAdvanceIndicator buildAdvanceIndicator, ScanResults scanResults, boolean enableScanResults) {
        if (enableScanResults) {
            run.addAction((Action)new InsightAppSecScanStepAction(scanResults));
        }
        if (buildAdvanceIndicator.equals((Object)BuildAdvanceIndicator.VULNERABILITY_QUERY) && !CollectionUtils.isEmpty(scanResults.getVulnerabilities())) {
            logger.log(String.format("Failing build due to %s non-filtered vulnerabilities", scanResults.getVulnerabilities().size()));
            throw new VulnerabilitySearchException();
        }
    }
}

