/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.insightappsec;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.jenkins.plugins.insightappsec.BuildAdvanceIndicator;
import io.jenkins.plugins.insightappsec.InsightAppSecLogger;
import io.jenkins.plugins.insightappsec.ScanDurationHandler;
import io.jenkins.plugins.insightappsec.ScanResults;
import io.jenkins.plugins.insightappsec.api.scan.Scan;
import io.jenkins.plugins.insightappsec.api.scan.ScanApi;
import io.jenkins.plugins.insightappsec.api.search.SearchApi;
import io.jenkins.plugins.insightappsec.api.search.SearchRequest;
import io.jenkins.plugins.insightappsec.api.vulnerability.Vulnerability;
import io.jenkins.plugins.insightappsec.exception.ScanFailureException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;

public class InsightAppSecScanStepRunner {
    private final ScanApi scanApi;
    private final SearchApi searchApi;
    private final InsightAppSecLogger logger;
    private final ScanDurationHandler scanDurationHandler;

    InsightAppSecScanStepRunner(ScanApi scanApi, SearchApi searchApi, InsightAppSecLogger logger, ScanDurationHandler scanDurationHandler) {
        this.scanApi = scanApi;
        this.searchApi = searchApi;
        this.logger = logger;
        this.scanDurationHandler = scanDurationHandler;
    }

    public Optional<ScanResults> run(String scanConfigId, BuildAdvanceIndicator buildAdvanceIndicator, @Nullable String vulnerabilityQuery) throws InterruptedException {
        String scanId = this.submitScan(scanConfigId);
        switch (buildAdvanceIndicator) {
            case SCAN_SUBMITTED: {
                return Optional.empty();
            }
            case SCAN_STARTED: {
                this.blockUntilStatus(scanId, Scan.ScanStatus.RUNNING);
                return Optional.empty();
            }
            case SCAN_COMPLETED: {
                this.blockUntilStatus(scanId, Scan.ScanStatus.COMPLETE);
                return Optional.of(new ScanResults(this.getAllVulnerabilities(scanId, null), this.scanApi.getScanExecutionDetails(scanId)));
            }
            case VULNERABILITY_QUERY: {
                this.blockUntilStatus(scanId, Scan.ScanStatus.COMPLETE);
                return Optional.of(new ScanResults(this.getAllVulnerabilities(scanId, vulnerabilityQuery), this.scanApi.getScanExecutionDetails(scanId)));
            }
        }
        return Optional.empty();
    }

    private void blockUntilStatus(String scanId, Scan.ScanStatus desiredStatus) throws InterruptedException {
        this.logger.log("Beginning polling for scan with id: %s", scanId);
        int pollIntervalSeconds = 15;
        int failureThreshold = 20;
        MutableInt failedCount = new MutableInt(0);
        Optional<Scan> scanOpt = this.tryGetScan(scanId, failureThreshold, failedCount);
        Optional<Object> cachedStatusOpt = Optional.empty();
        if (scanOpt.isPresent()) {
            cachedStatusOpt = Optional.of(scanOpt.get().getStatus());
            this.logger.log("Scan status: %s", cachedStatusOpt.get());
        }
        while (true) {
            if (scanOpt.isPresent()) {
                if (!cachedStatusOpt.isPresent()) {
                    cachedStatusOpt = Optional.of(scanOpt.get().getStatus());
                }
                if (cachedStatusOpt.get() != scanOpt.get().getStatus()) {
                    this.logger.log("Scan status has been updated from %s to %s", new Object[]{cachedStatusOpt.get(), scanOpt.get().getStatus()});
                    cachedStatusOpt = Optional.of(scanOpt.get().getStatus());
                }
                if (scanOpt.get().getStatus() == Scan.ScanStatus.CANCELING || scanOpt.get().getStatus() == Scan.ScanStatus.FAILED) {
                    this.logger.log("Failing build due to scan status: %s", new Object[]{scanOpt.get().getStatus()});
                    throw new ScanFailureException(scanOpt.get().getStatus());
                }
                if (scanOpt.get().getStatus() == desiredStatus) break;
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(pollIntervalSeconds));
            scanOpt = this.tryGetScan(scanId, failureThreshold, failedCount);
            scanOpt.ifPresent(scan -> {
                this.scanDurationHandler.handleMaxScanPendingDuration(scanId, scan.getStatus());
                this.scanDurationHandler.handleMaxScanExecutionDuration(scanId, scan.getStatus());
            });
        }
        this.logger.log("Desired scan status has been reached");
    }

    private String submitScan(String scanConfigId) {
        this.logger.log("Submitting scan for scan config with id: %s", scanConfigId);
        String scanId = this.scanApi.submitScan(scanConfigId);
        this.logger.log("Scan submitted successfully");
        this.logger.log("Scan id: %s", scanId);
        return scanId;
    }

    private Optional<Scan> tryGetScan(String scanId, int failureThreshold, MutableInt failedCount) {
        try {
            Scan scan = this.scanApi.getScan(scanId);
            failedCount.setValue(0);
            return Optional.of(scan);
        }
        catch (Exception e) {
            failedCount.add(1);
            if (failedCount.toInteger() > failureThreshold) {
                throw new RuntimeException(String.format("Scan polling has failed %s times, aborting", failedCount.toString()), e);
            }
            return Optional.empty();
        }
    }

    private List<Vulnerability> getAllVulnerabilities(String scanId, String vulnerabilityQuery) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("vulnerability.scans.id='%s'", scanId));
        if (!StringUtils.isEmpty((CharSequence)vulnerabilityQuery)) {
            if (vulnerabilityQuery.startsWith("(") && vulnerabilityQuery.endsWith(")")) {
                sb.append(String.format(" && %s", vulnerabilityQuery));
            } else {
                sb.append(String.format(" && (%s)", vulnerabilityQuery));
            }
        }
        SearchRequest searchRequest = new SearchRequest(SearchRequest.SearchType.VULNERABILITY, sb.toString());
        this.logger.log("Searching for vulnerabilities using query [%s]", searchRequest.getQuery());
        return this.searchApi.searchAll(searchRequest, Vulnerability.class);
    }
}

