/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.gitea;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import io.jenkins.plugins.checks.gitea.GiteaChecksContext;
import java.util.Objects;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.CheckReturnValue;

public class GiteaChecksContextAssert
extends AbstractObjectAssert<GiteaChecksContextAssert, GiteaChecksContext> {
    public GiteaChecksContextAssert(GiteaChecksContext actual) {
        super((Object)actual, GiteaChecksContextAssert.class);
    }

    @CheckReturnValue
    public static GiteaChecksContextAssert assertThat(GiteaChecksContext actual) {
        return new GiteaChecksContextAssert(actual);
    }

    public GiteaChecksContextAssert hasCredentials(StandardCredentials credentials) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting credentials of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        StandardCredentials actualCredentials = ((GiteaChecksContext)this.actual).getCredentials();
        if (!Objects.deepEquals(actualCredentials, credentials)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, credentials, actualCredentials});
        }
        return this;
    }

    public GiteaChecksContextAssert hasGiteaServerUrl(String giteaServerUrl) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting giteaServerUrl of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualGiteaServerUrl = ((GiteaChecksContext)this.actual).getGiteaServerUrl();
        if (!Objects.deepEquals(actualGiteaServerUrl, giteaServerUrl)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, giteaServerUrl, actualGiteaServerUrl});
        }
        return this;
    }

    public GiteaChecksContextAssert hasHeadSha(String headSha) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting headSha of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualHeadSha = ((GiteaChecksContext)this.actual).getHeadSha();
        if (!Objects.deepEquals(actualHeadSha, headSha)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, headSha, actualHeadSha});
        }
        return this;
    }

    public GiteaChecksContextAssert hasRepo(String repo) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting repo of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualRepo = ((GiteaChecksContext)this.actual).getRepo();
        if (!Objects.deepEquals(actualRepo, repo)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, repo, actualRepo});
        }
        return this;
    }

    public GiteaChecksContextAssert hasRepoOwner(String repoOwner) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting repoOwner of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualRepoOwner = ((GiteaChecksContext)this.actual).getRepoOwner();
        if (!Objects.deepEquals(actualRepoOwner, repoOwner)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, repoOwner, actualRepoOwner});
        }
        return this;
    }

    public GiteaChecksContextAssert hasRepository(String repository) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting repository of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualRepository = ((GiteaChecksContext)this.actual).getRepository();
        if (!Objects.deepEquals(actualRepository, repository)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, repository, actualRepository});
        }
        return this;
    }

    public GiteaChecksContextAssert hasURL(String uRL) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting uRL of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualURL = ((GiteaChecksContext)this.actual).getURL();
        if (!Objects.deepEquals(actualURL, uRL)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, uRL, actualURL});
        }
        return this;
    }
}

