/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error.provider;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.ollama.OllamaChatModel;
import dev.langchain4j.service.AiServices;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import io.jenkins.plugins.explain_error.ExplanationException;
import io.jenkins.plugins.explain_error.provider.BaseAIProvider;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class OllamaProvider
extends BaseAIProvider {
    private static final Logger LOGGER = Logger.getLogger(OllamaProvider.class.getName());

    @DataBoundConstructor
    public OllamaProvider(String url, String model) {
        super(url, model);
    }

    @Override
    public BaseAIProvider.Assistant createAssistant() {
        OllamaChatModel model = ((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().baseUrl(this.getUrl())).modelName(this.getModel())).temperature(Double.valueOf(0.3))).responseFormat(ResponseFormat.JSON)).timeout(Duration.ofSeconds(180L))).logRequests(Boolean.valueOf(LOGGER.isLoggable(Level.FINE)))).logResponses(Boolean.valueOf(LOGGER.isLoggable(Level.FINE)))).build();
        return (BaseAIProvider.Assistant)AiServices.create(BaseAIProvider.Assistant.class, (ChatModel)model);
    }

    @Override
    public boolean isNotValid(@CheckForNull TaskListener listener) {
        if (listener != null) {
            if (Util.fixEmptyAndTrim((String)this.getUrl()) == null) {
                listener.getLogger().println("No url configured for Ollama.");
            } else if (Util.fixEmptyAndTrim((String)this.getModel()) == null) {
                listener.getLogger().println("No Model configured for Ollama.");
            }
        }
        return Util.fixEmptyAndTrim((String)this.getUrl()) == null || Util.fixEmptyAndTrim((String)this.getModel()) == null;
    }

    @Extension
    @Symbol(value={"ollama"})
    public static class DescriptorImpl
    extends BaseAIProvider.BaseProviderDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Ollama";
        }

        @Override
        public String getDefaultModel() {
            return "gemma3:1b";
        }

        @Override
        @POST
        public FormValidation doCheckUrl(@QueryParameter String value) {
            if (value == null || value.isBlank()) {
                return FormValidation.error((String)"URL is required.");
            }
            return super.doCheckUrl(value);
        }

        @POST
        public FormValidation doTestConfiguration(@QueryParameter(value="url") String url, @QueryParameter(value="model") String model) throws ExplanationException {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            OllamaProvider provider = new OllamaProvider(url, model);
            try {
                provider.explainError("Send 'Configuration test successful' to me.", null);
                return FormValidation.ok((String)"Configuration test successful! API connection is working properly.");
            }
            catch (ExplanationException e) {
                return FormValidation.error((String)("Configuration test failed: " + e.getMessage()), (Object[])new Object[]{e});
            }
        }
    }
}

