/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error;

import com.google.common.annotations.VisibleForTesting;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import io.jenkins.plugins.explain_error.ErrorExplainer;
import io.jenkins.plugins.explain_error.ErrorExplanationAction;
import io.jenkins.plugins.explain_error.ExplanationException;
import io.jenkins.plugins.explain_error.GlobalConfigurationImpl;
import io.jenkins.plugins.explain_error.PipelineLogExtractor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.RunAction2;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ConsoleExplainErrorAction
implements RunAction2 {
    private static final Logger LOGGER = Logger.getLogger(ConsoleExplainErrorAction.class.getName());
    private transient Run<?, ?> run;
    private String urlString;

    public ConsoleExplainErrorAction(Run<?, ?> run) {
        this.run = run;
    }

    public void onAttached(Run<?, ?> r) {
        this.run = r;
    }

    public void onLoad(Run<?, ?> r) {
        this.run = r;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "console-explain-error";
    }

    @RequirePOST
    public void doExplainConsoleError(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        try {
            this.run.checkPermission(Item.READ);
            GlobalConfigurationImpl config = GlobalConfigurationImpl.get();
            if (!config.isEnableExplanation()) {
                this.writeJsonResponse(rsp, "warning", "Unkown", "AI error explanation is disabled in global configuration.");
                return;
            }
            boolean forceNew = "true".equals(req.getParameter("forceNew"));
            ErrorExplanationAction existingAction = (ErrorExplanationAction)this.run.getAction(ErrorExplanationAction.class);
            if (!forceNew && existingAction != null && existingAction.hasValidExplanation()) {
                this.writeJsonResponse(rsp, "success", existingAction.getProviderName(), this.createCachedResponse(existingAction.getExplanation()));
                return;
            }
            int maxLines = 200;
            String maxLinesParam = req.getParameter("maxLines");
            if (maxLinesParam != null) {
                try {
                    maxLines = Integer.parseInt(maxLinesParam);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            PipelineLogExtractor logExtractor = new PipelineLogExtractor(this.run, maxLines);
            List<String> logLines = logExtractor.getFailedStepLog();
            this.urlString = logExtractor.getUrl();
            String errorText = String.join((CharSequence)"\n", logLines);
            ErrorExplainer explainer = new ErrorExplainer();
            try {
                ErrorExplanationAction action = explainer.explainErrorText(errorText, this.urlString, this.run);
                this.writeJsonResponse(rsp, "success", action.getProviderName(), action.getExplanation());
            }
            catch (ExplanationException ee) {
                this.writeJsonResponse(rsp, ee.getLevel(), explainer.getProviderName(), ee.getMessage());
            }
        }
        catch (Exception e) {
            LOGGER.severe("=== EXPLAIN ERROR REQUEST FAILED ===");
            LOGGER.severe("Error explaining console error: " + e.getMessage());
            this.writeJsonResponse(rsp, "error", "Unkown", "Error: " + e.getMessage());
        }
    }

    @RequirePOST
    public void doCheckBuildStatus(StaplerRequest2 req, StaplerResponse2 rsp) throws ServletException, IOException {
        try {
            this.run.checkPermission(Item.READ);
            Integer buildingStatus = this.run.isBuilding() ? 1 : 0;
            if (buildingStatus == 0) {
                Result result = this.run.getResult();
                buildingStatus = result == Result.SUCCESS ? Integer.valueOf(0) : Integer.valueOf(2);
            }
            rsp.setContentType("application/json");
            rsp.setCharacterEncoding("UTF-8");
            PrintWriter writer = rsp.getWriter();
            String response = String.format("{\"buildingStatus\": %s}", buildingStatus);
            writer.write(response);
            writer.flush();
        }
        catch (Exception e) {
            LOGGER.severe("Error checking build status: " + e.getMessage());
            rsp.setStatus(500);
        }
    }

    private void writeJsonResponse(StaplerResponse2 rsp, String status, String providerName, String message) throws IOException {
        rsp.setContentType("application/json");
        rsp.setCharacterEncoding("UTF-8");
        PrintWriter writer = rsp.getWriter();
        JSONObject json = new JSONObject();
        json.put("status", (Object)status);
        json.put("providerName", (Object)providerName);
        json.put("message", (Object)message);
        json.put("url", (Object)this.urlString);
        writer.write(json.toString());
        writer.flush();
    }

    @VisibleForTesting
    String createCachedResponse(String explanation) {
        return explanation + "\n\n[Note: This is a previously generated explanation. Use the 'Generate New' option to create a new one.]";
    }

    public Run<?, ?> getRun() {
        return this.run;
    }
}

