/*
 * Decompiled with CFR 0.152.
 */
package io.superstudios.plugins.diversion;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import io.superstudios.plugins.diversion.DiversionSCM;
import io.superstudios.plugins.diversion.DiversionSCMFileSystem;
import io.superstudios.plugins.diversion.DiversionSCMHead;
import io.superstudios.plugins.diversion.DiversionSCMSource;
import java.io.IOException;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;

@Extension
public class DiversionSCMFileSystemBuilder
extends SCMFileSystem.Builder {
    public boolean supports(SCM source) {
        return source instanceof DiversionSCM;
    }

    public boolean supports(SCMSource source) {
        return source instanceof DiversionSCMSource;
    }

    public boolean supportsDescriptor(SCMSourceDescriptor descriptor) {
        return descriptor instanceof DiversionSCMSource.DescriptorImpl;
    }

    public boolean supportsDescriptor(SCMDescriptor descriptor) {
        return descriptor instanceof DiversionSCM.DescriptorImpl;
    }

    @CheckForNull
    public SCMFileSystem build(@NonNull Item owner, @NonNull SCM scm, @CheckForNull SCMRevision rev) throws IOException, InterruptedException {
        if (!(scm instanceof DiversionSCM)) {
            return null;
        }
        DiversionSCM diversionSCM = (DiversionSCM)scm;
        String libraryPath = diversionSCM.getLibraryPath();
        if (libraryPath == null || libraryPath.isEmpty()) {
            libraryPath = "";
        }
        String scriptPath = diversionSCM.getScriptPath();
        DiversionSCMFileSystem fs = new DiversionSCMFileSystem(diversionSCM.getRepositoryId(), diversionSCM.getBranch(), diversionSCM.getCredentialsId(), libraryPath, rev);
        if (scriptPath == null || scriptPath.isEmpty()) {
            fs.setJobName(owner.getName());
        } else {
            fs.setConfiguredScriptPath(scriptPath);
        }
        return fs;
    }

    @CheckForNull
    public SCMFileSystem build(@NonNull SCMSource source, @NonNull SCMHead head, @CheckForNull SCMRevision rev) throws IOException, InterruptedException {
        if (!(source instanceof DiversionSCMSource)) {
            return null;
        }
        if (!(head instanceof DiversionSCMHead)) {
            return null;
        }
        DiversionSCMSource diversionSource = (DiversionSCMSource)source;
        DiversionSCMHead diversionHead = (DiversionSCMHead)head;
        return new DiversionSCMFileSystem(diversionSource.getRepositoryId(), diversionHead.getBranchId(), diversionSource.getCredentialsId(), diversionSource.getLibraryPath(), rev);
    }
}

