/*
 * Decompiled with CFR 0.152.
 */
package io.superstudios.plugins.diversion;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.superstudios.plugins.diversion.DiversionApiClient;
import io.superstudios.plugins.diversion.DiversionFile;
import io.superstudios.plugins.diversion.DiversionSCMFileSystem;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jenkins.scm.api.SCMFile;

public class DiversionSCMFile
extends SCMFile {
    private final DiversionSCMFileSystem fileSystem;
    private final DiversionApiClient apiClient;
    private final String repositoryId;
    private final String branchId;
    private final String path;
    private Boolean isDirectory;

    protected DiversionSCMFile(@NonNull DiversionSCMFileSystem fileSystem, @NonNull String path, DiversionApiClient apiClient, String repositoryId, String branchId) {
        this.fileSystem = fileSystem;
        this.path = path;
        this.apiClient = apiClient;
        this.repositoryId = repositoryId;
        this.branchId = branchId;
    }

    private DiversionSCMFile(@NonNull DiversionSCMFile parent, @NonNull String name) {
        super((SCMFile)parent, name);
        this.fileSystem = parent.fileSystem;
        this.apiClient = parent.apiClient;
        this.repositoryId = parent.repositoryId;
        this.branchId = parent.branchId;
        this.path = parent.path.isEmpty() ? name : parent.path + "/" + name;
    }

    @NonNull
    protected SCMFile newChild(@NonNull String name, boolean assumeIsDirectory) {
        return new DiversionSCMFile(this, name);
    }

    @NonNull
    public Iterable<SCMFile> children() throws IOException, InterruptedException {
        ArrayList<SCMFile> children = new ArrayList<SCMFile>();
        List<DiversionFile> files = this.apiClient.getFileTree(this.repositoryId, this.branchId);
        String searchPath = this.path.isEmpty() ? "" : (this.path.endsWith("/") ? this.path : this.path + "/");
        LinkedHashMap<String, Boolean> childInfo = new LinkedHashMap<String, Boolean>();
        for (DiversionFile diversionFile : files) {
            String relativePath;
            String filePath = diversionFile.getPath();
            if (filePath == null || !filePath.startsWith(searchPath) || (relativePath = filePath.substring(searchPath.length())).isEmpty()) continue;
            int slashIndex = relativePath.indexOf(47);
            if (slashIndex == -1) {
                String childName = relativePath;
                String possibleDirPrefix = searchPath + childName + "/";
                boolean hasChildren = false;
                for (DiversionFile otherFile : files) {
                    if (otherFile.getPath() == null || !otherFile.getPath().startsWith(possibleDirPrefix)) continue;
                    hasChildren = true;
                    break;
                }
                if (childInfo.containsKey(childName) && ((Boolean)childInfo.get(childName)).booleanValue()) continue;
                childInfo.put(childName, hasChildren);
                continue;
            }
            String dirName = relativePath.substring(0, slashIndex);
            childInfo.put(dirName, true);
        }
        for (Map.Entry entry : childInfo.entrySet()) {
            String childName = (String)entry.getKey();
            boolean isDir = (Boolean)entry.getValue();
            DiversionSCMFile child = new DiversionSCMFile(this, childName);
            child.isDirectory = isDir;
            children.add(child);
        }
        return children;
    }

    public long lastModified() throws IOException, InterruptedException {
        return 0L;
    }

    @NonNull
    protected SCMFile.Type type() throws IOException, InterruptedException {
        if (this.isDirectory != null) {
            return this.isDirectory != false ? SCMFile.Type.DIRECTORY : SCMFile.Type.REGULAR_FILE;
        }
        try {
            if (this.path.isEmpty() || this.path.equals("vars") || this.path.equals("src") || this.path.equals("resources")) {
                this.isDirectory = true;
                return SCMFile.Type.DIRECTORY;
            }
            List<DiversionFile> files = this.apiClient.getFileTree(this.repositoryId, this.branchId);
            String searchPrefix = this.path + "/";
            boolean hasChildren = false;
            for (DiversionFile file : files) {
                if (file.getPath() == null || !file.getPath().startsWith(searchPrefix)) continue;
                hasChildren = true;
                break;
            }
            if (hasChildren) {
                this.isDirectory = true;
                return SCMFile.Type.DIRECTORY;
            }
            for (DiversionFile file : files) {
                if (!this.path.equals(file.getPath())) continue;
                this.isDirectory = false;
                return SCMFile.Type.REGULAR_FILE;
            }
            return SCMFile.Type.NONEXISTENT;
        }
        catch (IOException | InterruptedException e) {
            return SCMFile.Type.NONEXISTENT;
        }
    }

    @NonNull
    public InputStream content() throws IOException, InterruptedException {
        String fileContent = this.apiClient.getFileContent(this.repositoryId, this.branchId, this.path);
        return new ByteArrayInputStream(fileContent.getBytes(StandardCharsets.UTF_8));
    }

    @NonNull
    public String getPath() {
        return this.path;
    }
}

