/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.customizable_header;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.model.userproperty.UserPropertyCategory;
import io.jenkins.plugins.customizable_header.AbstractLink;
import io.jenkins.plugins.customizable_header.ContextAwareLogo;
import io.jenkins.plugins.customizable_header.color.HeaderColor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest2;

public class UserHeader
extends UserProperty {
    private boolean classicSearch;
    private boolean enabled;
    private boolean thinHeader;
    private HeaderColor headerColor;
    private List<AbstractLink> links = new ArrayList<AbstractLink>();
    private Set<String> dismissedMessages = new HashSet<String>();
    private ContextAwareLogo contextAwareLogo;

    @DataBoundConstructor
    public UserHeader() {
    }

    protected void setUser(User u) {
        super.setUser(u);
        if (this.headerColor != null && this.headerColor.getUserColors() == null) {
            this.headerColor.setUserColors(true);
            try {
                u.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isClassicSearch() {
        return this.classicSearch;
    }

    @DataBoundSetter
    public void setClassicSearch(boolean classicSearch) {
        this.classicSearch = classicSearch;
    }

    @DataBoundSetter
    public void setContextAwareLogo(ContextAwareLogo contextAwareLogo) {
        this.contextAwareLogo = contextAwareLogo;
    }

    public ContextAwareLogo getContextAwareLogo() {
        return this.contextAwareLogo;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @DataBoundSetter
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isThinHeader() {
        return this.thinHeader;
    }

    @DataBoundSetter
    public void setThinHeader(boolean thinHeader) {
        this.thinHeader = thinHeader;
    }

    @DataBoundSetter
    public void setHeaderColor(HeaderColor headerColor) {
        this.headerColor = headerColor;
    }

    public HeaderColor getHeaderColor() {
        return this.headerColor;
    }

    public List<AbstractLink> getLinks() {
        return this.links;
    }

    @DataBoundSetter
    public void setLinks(List<AbstractLink> links) {
        this.links = links;
    }

    public Object readResolve() throws IOException {
        if (this.dismissedMessages == null) {
            this.dismissedMessages = new HashSet<String>();
        }
        return this;
    }

    public void setDismissedMessages(Set<String> dismissedMessages) {
        this.dismissedMessages = dismissedMessages;
    }

    public Set<String> getDismissedMessages() {
        return this.dismissedMessages;
    }

    public UserProperty reconfigure(StaplerRequest2 req, @CheckForNull JSONObject form) {
        if (this.links != null) {
            this.links.clear();
        }
        this.contextAwareLogo = null;
        req.bindJSON((Object)this, form);
        this.headerColor.setUserColors(true);
        return this;
    }

    @Extension
    @Symbol(value={"customHeader"})
    public static class DescriptorImpl
    extends UserPropertyDescriptor {
        public UserProperty newInstance(User user) {
            UserHeader userHeader = new UserHeader();
            userHeader.setHeaderColor(new HeaderColor("inherit", "inherit", true));
            return userHeader;
        }

        @NonNull
        public String getDisplayName() {
            return "Customizable Header";
        }

        @NonNull
        public UserPropertyCategory getUserPropertyCategory() {
            return UserPropertyCategory.get(UserPropertyCategory.Appearance.class);
        }
    }
}

