/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.foldericon;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.FolderIcon;
import com.cloudbees.hudson.plugins.folder.FolderIconDescriptor;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.ionicons.Ionicons;
import jenkins.model.Jenkins;
import jenkins.plugins.foldericon.Messages;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class IoniconFolderIcon
extends FolderIcon {
    private static final String DEFAULT_ICON = "jenkins";
    private final String ionicon;
    private AbstractFolder<?> owner;

    @DataBoundConstructor
    public IoniconFolderIcon(String ionicon) {
        this.ionicon = StringUtils.isBlank((CharSequence)ionicon) ? DEFAULT_ICON : ionicon;
    }

    protected void setOwner(AbstractFolder<?> folder) {
        this.owner = folder;
    }

    public String getIonicon() {
        return this.ionicon;
    }

    public String getImageOf(String size) {
        return null;
    }

    public String getIconClassName() {
        return Ionicons.getIconClassName((String)this.getIonicon());
    }

    public String getDescription() {
        if (this.owner != null) {
            return this.owner.getPronoun();
        }
        return Messages.Folder_description();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    @Extension
    public static class DescriptorImpl
    extends FolderIconDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.IoniconFolderIcon_description();
        }
    }
}

