/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import io.jenkins.plugins.coverage.metrics.steps.CoverageQualityGate;
import io.jenkins.plugins.coverage.metrics.steps.CoverageRecorder;
import io.jenkins.plugins.coverage.metrics.steps.CoverageTool;
import io.jenkins.plugins.prism.SourceCodeDirectory;
import io.jenkins.plugins.prism.SourceCodeRetention;
import java.util.Collection;
import java.util.Objects;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;

public class CoverageRecorderAssert
extends AbstractObjectAssert<CoverageRecorderAssert, CoverageRecorder> {
    public CoverageRecorderAssert(CoverageRecorder actual) {
        super((Object)actual, CoverageRecorderAssert.class);
    }

    @CheckReturnValue
    public static CoverageRecorderAssert assertThat(CoverageRecorder actual) {
        return new CoverageRecorderAssert(actual);
    }

    public CoverageRecorderAssert hasActualId(String actualId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting actualId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualActualId = ((CoverageRecorder)this.actual).getActualId();
        if (!Objects.deepEquals(actualActualId, actualId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, actualId, actualActualId});
        }
        return this;
    }

    public CoverageRecorderAssert hasChecksAnnotationScope(CoverageRecorder.ChecksAnnotationScope checksAnnotationScope) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting checksAnnotationScope of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageRecorder.ChecksAnnotationScope actualChecksAnnotationScope = ((CoverageRecorder)this.actual).getChecksAnnotationScope();
        if (!Objects.deepEquals(actualChecksAnnotationScope, checksAnnotationScope)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, checksAnnotationScope, actualChecksAnnotationScope});
        }
        return this;
    }

    public CoverageRecorderAssert hasChecksName(String checksName) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting checksName of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualChecksName = ((CoverageRecorder)this.actual).getChecksName();
        if (!Objects.deepEquals(actualChecksName, checksName)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, checksName, actualChecksName});
        }
        return this;
    }

    public CoverageRecorderAssert hasDescriptor(BuildStepDescriptor descriptor) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting descriptor of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CoverageRecorder.Descriptor actualDescriptor = ((CoverageRecorder)this.actual).getDescriptor();
        if (!Objects.deepEquals(actualDescriptor, descriptor)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, descriptor, actualDescriptor});
        }
        return this;
    }

    public CoverageRecorderAssert isEnabledForFailure() {
        this.isNotNull();
        if (!((CoverageRecorder)this.actual).isEnabledForFailure()) {
            this.failWithMessage("\nExpecting that actual CoverageRecorder is enabled for failure but is not.", new Object[0]);
        }
        return this;
    }

    public CoverageRecorderAssert isNotEnabledForFailure() {
        this.isNotNull();
        if (((CoverageRecorder)this.actual).isEnabledForFailure()) {
            this.failWithMessage("\nExpecting that actual CoverageRecorder is not enabled for failure but is.", new Object[0]);
        }
        return this;
    }

    public CoverageRecorderAssert isFailOnError() {
        this.isNotNull();
        if (!((CoverageRecorder)this.actual).isFailOnError()) {
            this.failWithMessage("\nExpecting that actual CoverageRecorder is fail on error but is not.", new Object[0]);
        }
        return this;
    }

    public CoverageRecorderAssert isNotFailOnError() {
        this.isNotNull();
        if (((CoverageRecorder)this.actual).isFailOnError()) {
            this.failWithMessage("\nExpecting that actual CoverageRecorder is not fail on error but is.", new Object[0]);
        }
        return this;
    }

    public CoverageRecorderAssert hasId(String id) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting id of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualId = ((CoverageRecorder)this.actual).getId();
        if (!Objects.deepEquals(actualId, id)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, id, actualId});
        }
        return this;
    }

    public CoverageRecorderAssert isIgnoreParsingErrors() {
        this.isNotNull();
        if (!((CoverageRecorder)this.actual).isIgnoreParsingErrors()) {
            this.failWithMessage("\nExpecting that actual CoverageRecorder is ignore parsing errors but is not.", new Object[0]);
        }
        return this;
    }

    public CoverageRecorderAssert isNotIgnoreParsingErrors() {
        this.isNotNull();
        if (((CoverageRecorder)this.actual).isIgnoreParsingErrors()) {
            this.failWithMessage("\nExpecting that actual CoverageRecorder is not ignore parsing errors but is.", new Object[0]);
        }
        return this;
    }

    public CoverageRecorderAssert hasName(String name) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualName = ((CoverageRecorder)this.actual).getName();
        if (!Objects.deepEquals(actualName, name)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, name, actualName});
        }
        return this;
    }

    public CoverageRecorderAssert hasQualityGates(CoverageQualityGate ... qualityGates) {
        this.isNotNull();
        if (qualityGates == null) {
            this.failWithMessage("Expecting qualityGates parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageRecorder)this.actual).getQualityGates(), (Object[])qualityGates);
        return this;
    }

    public CoverageRecorderAssert hasQualityGates(Collection<? extends CoverageQualityGate> qualityGates) {
        this.isNotNull();
        if (qualityGates == null) {
            this.failWithMessage("Expecting qualityGates parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageRecorder)this.actual).getQualityGates(), qualityGates.toArray());
        return this;
    }

    public CoverageRecorderAssert hasOnlyQualityGates(CoverageQualityGate ... qualityGates) {
        this.isNotNull();
        if (qualityGates == null) {
            this.failWithMessage("Expecting qualityGates parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageRecorder)this.actual).getQualityGates(), (Object[])qualityGates);
        return this;
    }

    public CoverageRecorderAssert hasOnlyQualityGates(Collection<? extends CoverageQualityGate> qualityGates) {
        this.isNotNull();
        if (qualityGates == null) {
            this.failWithMessage("Expecting qualityGates parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageRecorder)this.actual).getQualityGates(), qualityGates.toArray());
        return this;
    }

    public CoverageRecorderAssert doesNotHaveQualityGates(CoverageQualityGate ... qualityGates) {
        this.isNotNull();
        if (qualityGates == null) {
            this.failWithMessage("Expecting qualityGates parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageRecorder)this.actual).getQualityGates(), (Object[])qualityGates);
        return this;
    }

    public CoverageRecorderAssert doesNotHaveQualityGates(Collection<? extends CoverageQualityGate> qualityGates) {
        this.isNotNull();
        if (qualityGates == null) {
            this.failWithMessage("Expecting qualityGates parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageRecorder)this.actual).getQualityGates(), qualityGates.toArray());
        return this;
    }

    public CoverageRecorderAssert hasNoQualityGates() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have qualityGates but had :\n  <%s>";
        if (((CoverageRecorder)this.actual).getQualityGates().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((CoverageRecorder)this.actual).getQualityGates()});
        }
        return this;
    }

    public CoverageRecorderAssert hasRequiredMonitorService(BuildStepMonitor requiredMonitorService) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting requiredMonitorService of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        BuildStepMonitor actualRequiredMonitorService = ((CoverageRecorder)this.actual).getRequiredMonitorService();
        if (!Objects.deepEquals(actualRequiredMonitorService, requiredMonitorService)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, requiredMonitorService, actualRequiredMonitorService});
        }
        return this;
    }

    public CoverageRecorderAssert hasScm(String scm) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting scm of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualScm = ((CoverageRecorder)this.actual).getScm();
        if (!Objects.deepEquals(actualScm, scm)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, scm, actualScm});
        }
        return this;
    }

    public CoverageRecorderAssert isSkipPublishingChecks() {
        this.isNotNull();
        if (!((CoverageRecorder)this.actual).isSkipPublishingChecks()) {
            this.failWithMessage("\nExpecting that actual CoverageRecorder is skip publishing checks but is not.", new Object[0]);
        }
        return this;
    }

    public CoverageRecorderAssert isNotSkipPublishingChecks() {
        this.isNotNull();
        if (((CoverageRecorder)this.actual).isSkipPublishingChecks()) {
            this.failWithMessage("\nExpecting that actual CoverageRecorder is not skip publishing checks but is.", new Object[0]);
        }
        return this;
    }

    public CoverageRecorderAssert isSkipSymbolicLinks() {
        this.isNotNull();
        if (!((CoverageRecorder)this.actual).isSkipSymbolicLinks()) {
            this.failWithMessage("\nExpecting that actual CoverageRecorder is skip symbolic links but is not.", new Object[0]);
        }
        return this;
    }

    public CoverageRecorderAssert isNotSkipSymbolicLinks() {
        this.isNotNull();
        if (((CoverageRecorder)this.actual).isSkipSymbolicLinks()) {
            this.failWithMessage("\nExpecting that actual CoverageRecorder is not skip symbolic links but is.", new Object[0]);
        }
        return this;
    }

    public CoverageRecorderAssert hasSourceCodeEncoding(String sourceCodeEncoding) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting sourceCodeEncoding of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualSourceCodeEncoding = ((CoverageRecorder)this.actual).getSourceCodeEncoding();
        if (!Objects.deepEquals(actualSourceCodeEncoding, sourceCodeEncoding)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, sourceCodeEncoding, actualSourceCodeEncoding});
        }
        return this;
    }

    public CoverageRecorderAssert hasSourceCodeRetention(SourceCodeRetention sourceCodeRetention) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting sourceCodeRetention of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        SourceCodeRetention actualSourceCodeRetention = ((CoverageRecorder)this.actual).getSourceCodeRetention();
        if (!Objects.deepEquals(actualSourceCodeRetention, sourceCodeRetention)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, sourceCodeRetention, actualSourceCodeRetention});
        }
        return this;
    }

    public CoverageRecorderAssert hasSourceDirectories(SourceCodeDirectory ... sourceDirectories) {
        this.isNotNull();
        if (sourceDirectories == null) {
            this.failWithMessage("Expecting sourceDirectories parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageRecorder)this.actual).getSourceDirectories(), (Object[])sourceDirectories);
        return this;
    }

    public CoverageRecorderAssert hasSourceDirectories(Collection<? extends SourceCodeDirectory> sourceDirectories) {
        this.isNotNull();
        if (sourceDirectories == null) {
            this.failWithMessage("Expecting sourceDirectories parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageRecorder)this.actual).getSourceDirectories(), sourceDirectories.toArray());
        return this;
    }

    public CoverageRecorderAssert hasOnlySourceDirectories(SourceCodeDirectory ... sourceDirectories) {
        this.isNotNull();
        if (sourceDirectories == null) {
            this.failWithMessage("Expecting sourceDirectories parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageRecorder)this.actual).getSourceDirectories(), (Object[])sourceDirectories);
        return this;
    }

    public CoverageRecorderAssert hasOnlySourceDirectories(Collection<? extends SourceCodeDirectory> sourceDirectories) {
        this.isNotNull();
        if (sourceDirectories == null) {
            this.failWithMessage("Expecting sourceDirectories parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageRecorder)this.actual).getSourceDirectories(), sourceDirectories.toArray());
        return this;
    }

    public CoverageRecorderAssert doesNotHaveSourceDirectories(SourceCodeDirectory ... sourceDirectories) {
        this.isNotNull();
        if (sourceDirectories == null) {
            this.failWithMessage("Expecting sourceDirectories parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageRecorder)this.actual).getSourceDirectories(), (Object[])sourceDirectories);
        return this;
    }

    public CoverageRecorderAssert doesNotHaveSourceDirectories(Collection<? extends SourceCodeDirectory> sourceDirectories) {
        this.isNotNull();
        if (sourceDirectories == null) {
            this.failWithMessage("Expecting sourceDirectories parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageRecorder)this.actual).getSourceDirectories(), sourceDirectories.toArray());
        return this;
    }

    public CoverageRecorderAssert hasNoSourceDirectories() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have sourceDirectories but had :\n  <%s>";
        if (((CoverageRecorder)this.actual).getSourceDirectories().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((CoverageRecorder)this.actual).getSourceDirectories()});
        }
        return this;
    }

    public CoverageRecorderAssert hasTools(CoverageTool ... tools) {
        this.isNotNull();
        if (tools == null) {
            this.failWithMessage("Expecting tools parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageRecorder)this.actual).getTools(), (Object[])tools);
        return this;
    }

    public CoverageRecorderAssert hasTools(Collection<? extends CoverageTool> tools) {
        this.isNotNull();
        if (tools == null) {
            this.failWithMessage("Expecting tools parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageRecorder)this.actual).getTools(), tools.toArray());
        return this;
    }

    public CoverageRecorderAssert hasOnlyTools(CoverageTool ... tools) {
        this.isNotNull();
        if (tools == null) {
            this.failWithMessage("Expecting tools parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageRecorder)this.actual).getTools(), (Object[])tools);
        return this;
    }

    public CoverageRecorderAssert hasOnlyTools(Collection<? extends CoverageTool> tools) {
        this.isNotNull();
        if (tools == null) {
            this.failWithMessage("Expecting tools parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageRecorder)this.actual).getTools(), tools.toArray());
        return this;
    }

    public CoverageRecorderAssert doesNotHaveTools(CoverageTool ... tools) {
        this.isNotNull();
        if (tools == null) {
            this.failWithMessage("Expecting tools parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageRecorder)this.actual).getTools(), (Object[])tools);
        return this;
    }

    public CoverageRecorderAssert doesNotHaveTools(Collection<? extends CoverageTool> tools) {
        this.isNotNull();
        if (tools == null) {
            this.failWithMessage("Expecting tools parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageRecorder)this.actual).getTools(), tools.toArray());
        return this;
    }

    public CoverageRecorderAssert hasNoTools() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have tools but had :\n  <%s>";
        if (((CoverageRecorder)this.actual).getTools().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((CoverageRecorder)this.actual).getTools()});
        }
        return this;
    }
}

