/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.restapi;

import hudson.model.Result;
import io.jenkins.plugins.coverage.metrics.restapi.CoverageApi;
import java.util.Collection;
import java.util.Objects;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;

public class CoverageApiQualityGateResultApiAssert
extends AbstractObjectAssert<CoverageApiQualityGateResultApiAssert, CoverageApi.QualityGateResultApi> {
    public CoverageApiQualityGateResultApiAssert(CoverageApi.QualityGateResultApi actual) {
        super((Object)actual, CoverageApiQualityGateResultApiAssert.class);
    }

    @CheckReturnValue
    public static CoverageApiQualityGateResultApiAssert assertThat(CoverageApi.QualityGateResultApi actual) {
        return new CoverageApiQualityGateResultApiAssert(actual);
    }

    public CoverageApiQualityGateResultApiAssert hasOverallResult(Result overallResult) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting overallResult of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Result actualOverallResult = ((CoverageApi.QualityGateResultApi)this.actual).getOverallResult();
        if (!Objects.deepEquals(actualOverallResult, overallResult)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, overallResult, actualOverallResult});
        }
        return this;
    }

    public CoverageApiQualityGateResultApiAssert hasResultItems(CoverageApi.QualityGateItemApi ... resultItems) {
        this.isNotNull();
        if (resultItems == null) {
            this.failWithMessage("Expecting resultItems parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageApi.QualityGateResultApi)this.actual).getResultItems(), (Object[])resultItems);
        return this;
    }

    public CoverageApiQualityGateResultApiAssert hasResultItems(Collection<? extends CoverageApi.QualityGateItemApi> resultItems) {
        this.isNotNull();
        if (resultItems == null) {
            this.failWithMessage("Expecting resultItems parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((CoverageApi.QualityGateResultApi)this.actual).getResultItems(), resultItems.toArray());
        return this;
    }

    public CoverageApiQualityGateResultApiAssert hasOnlyResultItems(CoverageApi.QualityGateItemApi ... resultItems) {
        this.isNotNull();
        if (resultItems == null) {
            this.failWithMessage("Expecting resultItems parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageApi.QualityGateResultApi)this.actual).getResultItems(), (Object[])resultItems);
        return this;
    }

    public CoverageApiQualityGateResultApiAssert hasOnlyResultItems(Collection<? extends CoverageApi.QualityGateItemApi> resultItems) {
        this.isNotNull();
        if (resultItems == null) {
            this.failWithMessage("Expecting resultItems parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((CoverageApi.QualityGateResultApi)this.actual).getResultItems(), resultItems.toArray());
        return this;
    }

    public CoverageApiQualityGateResultApiAssert doesNotHaveResultItems(CoverageApi.QualityGateItemApi ... resultItems) {
        this.isNotNull();
        if (resultItems == null) {
            this.failWithMessage("Expecting resultItems parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageApi.QualityGateResultApi)this.actual).getResultItems(), (Object[])resultItems);
        return this;
    }

    public CoverageApiQualityGateResultApiAssert doesNotHaveResultItems(Collection<? extends CoverageApi.QualityGateItemApi> resultItems) {
        this.isNotNull();
        if (resultItems == null) {
            this.failWithMessage("Expecting resultItems parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((CoverageApi.QualityGateResultApi)this.actual).getResultItems(), resultItems.toArray());
        return this;
    }

    public CoverageApiQualityGateResultApiAssert hasNoResultItems() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have resultItems but had :\n  <%s>";
        if (((CoverageApi.QualityGateResultApi)this.actual).getResultItems().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((CoverageApi.QualityGateResultApi)this.actual).getResultItems()});
        }
        return this;
    }
}

