/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.restapi;

import hudson.model.Result;
import io.jenkins.plugins.coverage.metrics.restapi.CoverageApi;
import java.util.Objects;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.CheckReturnValue;

public class CoverageApiQualityGateItemApiAssert
extends AbstractObjectAssert<CoverageApiQualityGateItemApiAssert, CoverageApi.QualityGateItemApi> {
    public CoverageApiQualityGateItemApiAssert(CoverageApi.QualityGateItemApi actual) {
        super((Object)actual, CoverageApiQualityGateItemApiAssert.class);
    }

    @CheckReturnValue
    public static CoverageApiQualityGateItemApiAssert assertThat(CoverageApi.QualityGateItemApi actual) {
        return new CoverageApiQualityGateItemApiAssert(actual);
    }

    public CoverageApiQualityGateItemApiAssert hasQualityGate(String qualityGate) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting qualityGate of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualQualityGate = ((CoverageApi.QualityGateItemApi)this.actual).getQualityGate();
        if (!Objects.deepEquals(actualQualityGate, qualityGate)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, qualityGate, actualQualityGate});
        }
        return this;
    }

    public CoverageApiQualityGateItemApiAssert hasResult(Result result) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting result of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Result actualResult = ((CoverageApi.QualityGateItemApi)this.actual).getResult();
        if (!Objects.deepEquals(actualResult, result)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, result, actualResult});
        }
        return this;
    }

    public CoverageApiQualityGateItemApiAssert hasThreshold(double threshold) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting threshold of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        double actualThreshold = ((CoverageApi.QualityGateItemApi)this.actual).getThreshold();
        if (actualThreshold != threshold) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, threshold, actualThreshold});
        }
        return this;
    }

    public CoverageApiQualityGateItemApiAssert hasThresholdCloseTo(double threshold, double assertjOffset) {
        this.isNotNull();
        double actualThreshold = ((CoverageApi.QualityGateItemApi)this.actual).getThreshold();
        String assertjErrorMessage = String.format("\nExpecting threshold:\n  <%s>\nto be close to:\n  <%s>\nby less than <%s> but difference was <%s>", actualThreshold, threshold, assertjOffset, Math.abs(threshold - actualThreshold));
        ((AbstractDoubleAssert)Assertions.assertThat((double)actualThreshold).overridingErrorMessage(assertjErrorMessage, new Object[0])).isCloseTo(threshold, Assertions.within((Double)assertjOffset));
        return this;
    }

    public CoverageApiQualityGateItemApiAssert hasValue(String value) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting value of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualValue = ((CoverageApi.QualityGateItemApi)this.actual).getValue();
        if (!Objects.deepEquals(actualValue, value)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, value, actualValue});
        }
        return this;
    }
}

