/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.color;

import io.jenkins.plugins.coverage.metrics.color.ColorId;
import io.jenkins.plugins.coverage.metrics.color.CoverageLevel;
import java.util.Objects;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.CheckReturnValue;

public class CoverageLevelAssert
extends AbstractComparableAssert<CoverageLevelAssert, CoverageLevel> {
    public CoverageLevelAssert(CoverageLevel actual) {
        super((Comparable)actual, CoverageLevelAssert.class);
    }

    @CheckReturnValue
    public static CoverageLevelAssert assertThat(CoverageLevel actual) {
        return new CoverageLevelAssert(actual);
    }

    public CoverageLevelAssert hasColorizationId(ColorId colorizationId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting colorizationId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        ColorId actualColorizationId = ((CoverageLevel)this.actual).getColorizationId();
        if (!Objects.deepEquals(actualColorizationId, colorizationId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, colorizationId, actualColorizationId});
        }
        return this;
    }

    public CoverageLevelAssert hasLevel(double level) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting level of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        double actualLevel = ((CoverageLevel)this.actual).getLevel();
        if (actualLevel != level) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, level, actualLevel});
        }
        return this;
    }

    public CoverageLevelAssert hasLevelCloseTo(double level, double assertjOffset) {
        this.isNotNull();
        double actualLevel = ((CoverageLevel)this.actual).getLevel();
        String assertjErrorMessage = String.format("\nExpecting level:\n  <%s>\nto be close to:\n  <%s>\nby less than <%s> but difference was <%s>", actualLevel, level, assertjOffset, Math.abs(level - actualLevel));
        ((AbstractDoubleAssert)Assertions.assertThat((double)actualLevel).overridingErrorMessage(assertjErrorMessage, new Object[0])).isCloseTo(level, Assertions.within((Double)assertjOffset));
        return this;
    }
}

