/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.noconflict;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Slave;
import hudson.slaves.OfflineCause;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import hudson.util.FormValidation;
import io.jenkins.plugins.noconflict.Messages;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class OnDemandNoConflicts
extends RetentionStrategy<SlaveComputer> {
    private static final Logger logger = Logger.getLogger(RetentionStrategy.Demand.class.getName());
    private final long inDemandDelay;
    private final long idleDelay;
    private String conflictsWith;

    @DataBoundConstructor
    public OnDemandNoConflicts(long inDemandDelay, long idleDelay) {
        this.inDemandDelay = Math.max(0L, inDemandDelay);
        this.idleDelay = Math.max(1L, idleDelay);
    }

    public long getInDemandDelay() {
        return this.inDemandDelay;
    }

    public long getIdleDelay() {
        return this.idleDelay;
    }

    public String getConflictsWith() {
        return this.conflictsWith;
    }

    @DataBoundSetter
    public void setConflictsWith(String value) {
        this.conflictsWith = value.trim();
    }

    public long check(SlaveComputer c) {
        if (c.isOffline() && c.isLaunchSupported()) {
            HashSet<String> hasConflict = new HashSet<String>();
            Pattern conflictsWithPattern = null;
            String cName = c.getName();
            if (this.conflictsWith != null && !this.conflictsWith.equals("")) {
                try {
                    conflictsWithPattern = Pattern.compile(this.conflictsWith);
                }
                catch (PatternSyntaxException ep) {
                    logger.log(Level.SEVERE, "Invalid conflictsWith regex ~/{0}/ for computer {1}, ignored: {2}", new Object[]{this.conflictsWith, cName, ep.getMessage()});
                    conflictsWithPattern = null;
                }
            }
            HashMap<Object, Integer> availableComputers = new HashMap<Object, Integer>();
            for (Computer o : Jenkins.get().getComputers()) {
                int idleExecutors;
                Matcher matcher;
                if (!o.isOnline() && !o.isConnecting()) continue;
                String oName = o.getName();
                if (conflictsWithPattern != null && !oName.equals(cName) && (matcher = conflictsWithPattern.matcher(oName)).find()) {
                    hasConflict.add(oName);
                }
                if (hasConflict.contains(oName) || !o.isPartiallyIdle() || !o.isAcceptingTasks() || (idleExecutors = o.countIdle()) <= 0) continue;
                availableComputers.put(o, idleExecutors);
            }
            boolean needComputer = false;
            long demandMilliseconds = 0L;
            for (Queue.BuildableItem item : Queue.getInstance().getBuildableItems()) {
                boolean needExecutor = true;
                for (Computer o : Collections.unmodifiableSet(availableComputers.keySet())) {
                    Node otherNode = o.getNode();
                    if (otherNode == null || otherNode.canTake(item) != null) continue;
                    needExecutor = false;
                    int availableExecutors = (Integer)availableComputers.remove(o);
                    if (availableExecutors > 1) {
                        availableComputers.put(o, availableExecutors - 1);
                        break;
                    }
                    availableComputers.remove(o);
                    break;
                }
                Slave checkedNode = c.getNode();
                if (!needExecutor || checkedNode == null || checkedNode.canTake(item) != null) continue;
                demandMilliseconds = System.currentTimeMillis() - item.buildableStartMilliseconds;
                needComputer = demandMilliseconds > TimeUnit.MINUTES.toMillis(this.inDemandDelay);
                break;
            }
            if (needComputer) {
                if (!hasConflict.isEmpty()) {
                    msg = MessageFormat.format("Would launch computer [{0}] as it has been in demand for {1}, but it conflicts by regex ~/{2}/ with already active computer(s): {3}", c.getName(), Util.getTimeSpanString((long)demandMilliseconds), this.conflictsWith, ((Object)hasConflict).toString());
                    c.getListener().getLogger().println(msg);
                    logger.log(Level.WARNING, "{0}", msg);
                } else {
                    msg = MessageFormat.format("Launching computer [{0}] as it has been in demand for {1}{2}", c.getName(), Util.getTimeSpanString((long)demandMilliseconds), conflictsWithPattern == null ? "" : " and has no conflicting computers matched by regex ~/" + this.conflictsWith + "/");
                    logger.log(Level.INFO, "{0}", msg);
                    c.connect(false);
                    c.getListener().getLogger().println(msg);
                }
            }
        } else if (c.isIdle()) {
            long idleMilliseconds = System.currentTimeMillis() - c.getIdleStartMilliseconds();
            if (idleMilliseconds > TimeUnit.MINUTES.toMillis(this.idleDelay)) {
                String msg = MessageFormat.format("Disconnecting computer [{0}] as it has been idle for {1}", c.getName(), Util.getTimeSpanString((long)idleMilliseconds));
                logger.log(Level.INFO, "{0}", msg);
                c.getListener().getLogger().println(msg);
                c.disconnect((OfflineCause)new OfflineCause.IdleOfflineCause());
            } else {
                return TimeUnit.MILLISECONDS.toMinutes(TimeUnit.MINUTES.toMillis(this.idleDelay) - idleMilliseconds);
            }
        }
        return 1L;
    }

    @Extension
    @Symbol(value={"demand"})
    public static class DescriptorImpl
    extends Descriptor<RetentionStrategy<?>> {
        public String getDisplayName() {
            return Messages.displayName();
        }

        @NonNull
        public FormValidation doCheckConflictsWith(@QueryParameter String value) {
            try {
                Pattern pattern = null;
                if (value != null && !value.trim().equals("")) {
                    pattern = Pattern.compile(value);
                    assert (pattern != null);
                }
            }
            catch (PatternSyntaxException ep) {
                return FormValidation.error((String)("Invalid regex: " + ep.getMessage()));
            }
            catch (Failure ef) {
                return FormValidation.error((String)("Failed to validate regex: " + ef.getMessage()));
            }
            return FormValidation.ok();
        }
    }
}

