// CHECKSTYLE:OFF

package io.jenkins.plugins.noconflict;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code displayName}: {@code On Demand (Conflict Aware)}.
     * 
     * @return
     *     {@code On Demand (Conflict Aware)}
     */
    public static String displayName() {
        return holder.format("displayName");
    }

    /**
     * Key {@code displayName}: {@code On Demand (Conflict Aware)}.
     * 
     * @return
     *     {@code On Demand (Conflict Aware)}
     */
    public static Localizable _displayName() {
        return new Localizable(holder, "displayName");
    }

}
