/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.steps;

import hudson.model.Descriptor;
import io.jenkins.plugins.checks.steps.WithChecksStep;
import java.util.Objects;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.CheckReturnValue;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;

public class WithChecksStepAssert
extends AbstractObjectAssert<WithChecksStepAssert, WithChecksStep> {
    public WithChecksStepAssert(WithChecksStep actual) {
        super((Object)actual, WithChecksStepAssert.class);
    }

    @CheckReturnValue
    public static WithChecksStepAssert assertThat(WithChecksStep actual) {
        return new WithChecksStepAssert(actual);
    }

    public WithChecksStepAssert hasDescriptor(Descriptor descriptor) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting descriptor of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        StepDescriptor actualDescriptor = ((WithChecksStep)this.actual).getDescriptor();
        if (!Objects.deepEquals(actualDescriptor, descriptor)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, descriptor, actualDescriptor});
        }
        return this;
    }

    public WithChecksStepAssert isIncludeStage() {
        this.isNotNull();
        if (!((WithChecksStep)this.actual).isIncludeStage()) {
            this.failWithMessage("\nExpecting that actual WithChecksStep is include stage but is not.", new Object[0]);
        }
        return this;
    }

    public WithChecksStepAssert isNotIncludeStage() {
        this.isNotNull();
        if (((WithChecksStep)this.actual).isIncludeStage()) {
            this.failWithMessage("\nExpecting that actual WithChecksStep is not include stage but is.", new Object[0]);
        }
        return this;
    }

    public WithChecksStepAssert hasName(String name) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualName = ((WithChecksStep)this.actual).getName();
        if (!Objects.deepEquals(actualName, name)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, name, actualName});
        }
        return this;
    }
}

