/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.api;

import io.jenkins.plugins.checks.api.ChecksAnnotation;
import io.jenkins.plugins.checks.api.ChecksImage;
import io.jenkins.plugins.checks.api.ChecksOutput;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;

public class ChecksOutputAssert
extends AbstractObjectAssert<ChecksOutputAssert, ChecksOutput> {
    public ChecksOutputAssert(ChecksOutput actual) {
        super((Object)actual, ChecksOutputAssert.class);
    }

    @CheckReturnValue
    public static ChecksOutputAssert assertThat(ChecksOutput actual) {
        return new ChecksOutputAssert(actual);
    }

    public ChecksOutputAssert hasChecksAnnotations(ChecksAnnotation ... checksAnnotations) {
        this.isNotNull();
        if (checksAnnotations == null) {
            this.failWithMessage("Expecting checksAnnotations parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ChecksOutput)this.actual).getChecksAnnotations(), (Object[])checksAnnotations);
        return this;
    }

    public ChecksOutputAssert hasChecksAnnotations(Collection<? extends ChecksAnnotation> checksAnnotations) {
        this.isNotNull();
        if (checksAnnotations == null) {
            this.failWithMessage("Expecting checksAnnotations parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ChecksOutput)this.actual).getChecksAnnotations(), checksAnnotations.toArray());
        return this;
    }

    public ChecksOutputAssert hasOnlyChecksAnnotations(ChecksAnnotation ... checksAnnotations) {
        this.isNotNull();
        if (checksAnnotations == null) {
            this.failWithMessage("Expecting checksAnnotations parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ChecksOutput)this.actual).getChecksAnnotations(), (Object[])checksAnnotations);
        return this;
    }

    public ChecksOutputAssert hasOnlyChecksAnnotations(Collection<? extends ChecksAnnotation> checksAnnotations) {
        this.isNotNull();
        if (checksAnnotations == null) {
            this.failWithMessage("Expecting checksAnnotations parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ChecksOutput)this.actual).getChecksAnnotations(), checksAnnotations.toArray());
        return this;
    }

    public ChecksOutputAssert doesNotHaveChecksAnnotations(ChecksAnnotation ... checksAnnotations) {
        this.isNotNull();
        if (checksAnnotations == null) {
            this.failWithMessage("Expecting checksAnnotations parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ChecksOutput)this.actual).getChecksAnnotations(), (Object[])checksAnnotations);
        return this;
    }

    public ChecksOutputAssert doesNotHaveChecksAnnotations(Collection<? extends ChecksAnnotation> checksAnnotations) {
        this.isNotNull();
        if (checksAnnotations == null) {
            this.failWithMessage("Expecting checksAnnotations parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ChecksOutput)this.actual).getChecksAnnotations(), checksAnnotations.toArray());
        return this;
    }

    public ChecksOutputAssert hasNoChecksAnnotations() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have checksAnnotations but had :\n  <%s>";
        if (((ChecksOutput)this.actual).getChecksAnnotations().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ChecksOutput)this.actual).getChecksAnnotations()});
        }
        return this;
    }

    public ChecksOutputAssert hasChecksImages(ChecksImage ... checksImages) {
        this.isNotNull();
        if (checksImages == null) {
            this.failWithMessage("Expecting checksImages parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ChecksOutput)this.actual).getChecksImages(), (Object[])checksImages);
        return this;
    }

    public ChecksOutputAssert hasChecksImages(Collection<? extends ChecksImage> checksImages) {
        this.isNotNull();
        if (checksImages == null) {
            this.failWithMessage("Expecting checksImages parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ChecksOutput)this.actual).getChecksImages(), checksImages.toArray());
        return this;
    }

    public ChecksOutputAssert hasOnlyChecksImages(ChecksImage ... checksImages) {
        this.isNotNull();
        if (checksImages == null) {
            this.failWithMessage("Expecting checksImages parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ChecksOutput)this.actual).getChecksImages(), (Object[])checksImages);
        return this;
    }

    public ChecksOutputAssert hasOnlyChecksImages(Collection<? extends ChecksImage> checksImages) {
        this.isNotNull();
        if (checksImages == null) {
            this.failWithMessage("Expecting checksImages parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ChecksOutput)this.actual).getChecksImages(), checksImages.toArray());
        return this;
    }

    public ChecksOutputAssert doesNotHaveChecksImages(ChecksImage ... checksImages) {
        this.isNotNull();
        if (checksImages == null) {
            this.failWithMessage("Expecting checksImages parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ChecksOutput)this.actual).getChecksImages(), (Object[])checksImages);
        return this;
    }

    public ChecksOutputAssert doesNotHaveChecksImages(Collection<? extends ChecksImage> checksImages) {
        this.isNotNull();
        if (checksImages == null) {
            this.failWithMessage("Expecting checksImages parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ChecksOutput)this.actual).getChecksImages(), checksImages.toArray());
        return this;
    }

    public ChecksOutputAssert hasNoChecksImages() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have checksImages but had :\n  <%s>";
        if (((ChecksOutput)this.actual).getChecksImages().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ChecksOutput)this.actual).getChecksImages()});
        }
        return this;
    }

    public ChecksOutputAssert hasSummary(Optional summary) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting summary of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Optional actualSummary = ((ChecksOutput)this.actual).getSummary();
        if (!Objects.deepEquals(actualSummary, summary)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, summary, actualSummary});
        }
        return this;
    }

    public ChecksOutputAssert hasText(Optional text) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting text of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Optional actualText = ((ChecksOutput)this.actual).getText();
        if (!Objects.deepEquals(actualText, text)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, text, actualText});
        }
        return this;
    }

    public ChecksOutputAssert hasTitle(Optional title) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting title of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Optional actualTitle = ((ChecksOutput)this.actual).getTitle();
        if (!Objects.deepEquals(actualTitle, title)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, title, actualTitle});
        }
        return this;
    }
}

