/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.api;

import io.jenkins.plugins.checks.api.ChecksImage;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.util.CheckReturnValue;

public class ChecksImageAssert
extends AbstractObjectAssert<ChecksImageAssert, ChecksImage> {
    public ChecksImageAssert(ChecksImage actual) {
        super((Object)actual, ChecksImageAssert.class);
    }

    @CheckReturnValue
    public static ChecksImageAssert assertThat(ChecksImage actual) {
        return new ChecksImageAssert(actual);
    }

    public ChecksImageAssert hasAlt(Optional alt) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting alt of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Optional actualAlt = ((ChecksImage)this.actual).getAlt();
        if (!Objects.deepEquals(actualAlt, alt)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, alt, actualAlt});
        }
        return this;
    }

    public ChecksImageAssert hasCaption(Optional caption) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting caption of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Optional actualCaption = ((ChecksImage)this.actual).getCaption();
        if (!Objects.deepEquals(actualCaption, caption)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, caption, actualCaption});
        }
        return this;
    }

    public ChecksImageAssert hasImageURL(Optional imageURL) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting imageURL of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Optional actualImageURL = ((ChecksImage)this.actual).getImageURL();
        if (!Objects.deepEquals(actualImageURL, imageURL)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, imageURL, actualImageURL});
        }
        return this;
    }

    public ChecksImageAssert hasImageUrl(Optional imageUrl) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting imageUrl of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Optional actualImageUrl = ((ChecksImage)this.actual).getImageUrl();
        if (!Objects.deepEquals(actualImageUrl, imageUrl)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, imageUrl, actualImageUrl});
        }
        return this;
    }
}

