/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.checks.api;

import io.jenkins.plugins.checks.api.ChecksAction;
import io.jenkins.plugins.checks.api.ChecksConclusion;
import io.jenkins.plugins.checks.api.ChecksDetails;
import io.jenkins.plugins.checks.api.ChecksStatus;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.CheckReturnValue;

public class ChecksDetailsAssert
extends AbstractObjectAssert<ChecksDetailsAssert, ChecksDetails> {
    public ChecksDetailsAssert(ChecksDetails actual) {
        super((Object)actual, ChecksDetailsAssert.class);
    }

    @CheckReturnValue
    public static ChecksDetailsAssert assertThat(ChecksDetails actual) {
        return new ChecksDetailsAssert(actual);
    }

    public ChecksDetailsAssert hasActions(ChecksAction ... actions) {
        this.isNotNull();
        if (actions == null) {
            this.failWithMessage("Expecting actions parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ChecksDetails)this.actual).getActions(), (Object[])actions);
        return this;
    }

    public ChecksDetailsAssert hasActions(Collection<? extends ChecksAction> actions) {
        this.isNotNull();
        if (actions == null) {
            this.failWithMessage("Expecting actions parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((ChecksDetails)this.actual).getActions(), actions.toArray());
        return this;
    }

    public ChecksDetailsAssert hasOnlyActions(ChecksAction ... actions) {
        this.isNotNull();
        if (actions == null) {
            this.failWithMessage("Expecting actions parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ChecksDetails)this.actual).getActions(), (Object[])actions);
        return this;
    }

    public ChecksDetailsAssert hasOnlyActions(Collection<? extends ChecksAction> actions) {
        this.isNotNull();
        if (actions == null) {
            this.failWithMessage("Expecting actions parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((ChecksDetails)this.actual).getActions(), actions.toArray());
        return this;
    }

    public ChecksDetailsAssert doesNotHaveActions(ChecksAction ... actions) {
        this.isNotNull();
        if (actions == null) {
            this.failWithMessage("Expecting actions parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ChecksDetails)this.actual).getActions(), (Object[])actions);
        return this;
    }

    public ChecksDetailsAssert doesNotHaveActions(Collection<? extends ChecksAction> actions) {
        this.isNotNull();
        if (actions == null) {
            this.failWithMessage("Expecting actions parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((ChecksDetails)this.actual).getActions(), actions.toArray());
        return this;
    }

    public ChecksDetailsAssert hasNoActions() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have actions but had :\n  <%s>";
        if (((ChecksDetails)this.actual).getActions().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ChecksDetails)this.actual).getActions()});
        }
        return this;
    }

    public ChecksDetailsAssert hasCompletedAt(Optional completedAt) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting completedAt of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Optional actualCompletedAt = ((ChecksDetails)this.actual).getCompletedAt();
        if (!Objects.deepEquals(actualCompletedAt, completedAt)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, completedAt, actualCompletedAt});
        }
        return this;
    }

    public ChecksDetailsAssert hasConclusion(ChecksConclusion conclusion) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting conclusion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        ChecksConclusion actualConclusion = ((ChecksDetails)this.actual).getConclusion();
        if (!Objects.deepEquals(actualConclusion, conclusion)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, conclusion, actualConclusion});
        }
        return this;
    }

    public ChecksDetailsAssert hasDetailsURL(Optional detailsURL) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting detailsURL of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Optional actualDetailsURL = ((ChecksDetails)this.actual).getDetailsURL();
        if (!Objects.deepEquals(actualDetailsURL, detailsURL)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, detailsURL, actualDetailsURL});
        }
        return this;
    }

    public ChecksDetailsAssert hasName(Optional name) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Optional actualName = ((ChecksDetails)this.actual).getName();
        if (!Objects.deepEquals(actualName, name)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, name, actualName});
        }
        return this;
    }

    public ChecksDetailsAssert hasOutput(Optional output) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting output of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Optional actualOutput = ((ChecksDetails)this.actual).getOutput();
        if (!Objects.deepEquals(actualOutput, output)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, output, actualOutput});
        }
        return this;
    }

    public ChecksDetailsAssert hasStartedAt(Optional startedAt) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting startedAt of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Optional actualStartedAt = ((ChecksDetails)this.actual).getStartedAt();
        if (!Objects.deepEquals(actualStartedAt, startedAt)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, startedAt, actualStartedAt});
        }
        return this;
    }

    public ChecksDetailsAssert hasStatus(ChecksStatus status) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting status of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        ChecksStatus actualStatus = ((ChecksDetails)this.actual).getStatus();
        if (!Objects.deepEquals(actualStatus, status)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, status, actualStatus});
        }
        return this;
    }
}

