/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.view.calendar.service;

import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.util.RunList;
import io.jenkins.plugins.view.calendar.CalendarView;
import io.jenkins.plugins.view.calendar.event.CalendarEvent;
import io.jenkins.plugins.view.calendar.event.CalendarEventComparator;
import io.jenkins.plugins.view.calendar.event.CalendarEventFactory;
import io.jenkins.plugins.view.calendar.event.CalendarEventState;
import io.jenkins.plugins.view.calendar.event.ScheduledCalendarEvent;
import io.jenkins.plugins.view.calendar.event.StartedCalendarEvent;
import io.jenkins.plugins.view.calendar.service.CronJobService;
import io.jenkins.plugins.view.calendar.service.CronWrapper;
import io.jenkins.plugins.view.calendar.time.Moment;
import io.jenkins.plugins.view.calendar.time.MomentRange;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class CalendarEventService {
    private final transient CronJobService cronJobService;
    private final transient Moment now;
    private final transient CalendarEventFactory calendarEventFactory;

    public CalendarEventService(Moment now, CronJobService cronJobService) {
        this.now = now;
        this.cronJobService = cronJobService;
        this.calendarEventFactory = new CalendarEventFactory(now, this);
    }

    public List<CalendarEvent> getCalendarEvents(List<? extends Job> jobs, MomentRange inclusionRange, CalendarView.CalendarViewEventsType eventsType) {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        if (this.now.isBefore(inclusionRange.getStart())) {
            events.addAll(this.getRunningEvents(jobs, inclusionRange, eventsType));
            if (MomentRange.isValidRange(this.now.nextMinute(), inclusionRange.getStart().previousMinute())) {
                events.addAll(this.getScheduledEventsBackward(jobs, MomentRange.range(this.now.nextMinute(), inclusionRange.getStart().previousMinute()), inclusionRange, eventsType));
            }
            events.addAll(this.getScheduledEventsForward(jobs, inclusionRange, inclusionRange, eventsType));
        } else if (this.now.isSame(inclusionRange.getStart())) {
            events.addAll(this.getRunningEvents(jobs, inclusionRange, eventsType));
            events.addAll(this.getScheduledEventsForward(jobs, MomentRange.range(this.now.nextMinute(), inclusionRange.getEnd()), inclusionRange, eventsType));
        } else if (this.now.isSame(inclusionRange.getEnd())) {
            events.addAll(this.getStartedEvents(jobs, inclusionRange, null, eventsType));
        } else if (this.now.isAfter(inclusionRange.getEnd())) {
            events.addAll(this.getStartedEvents(jobs, inclusionRange, null, eventsType));
        } else {
            events.addAll(this.getStartedEvents(jobs, MomentRange.range(inclusionRange.getStart(), this.now.nextMinute()), null, eventsType));
            if (MomentRange.isValidRange(this.now.nextMinute(), inclusionRange.getEnd())) {
                events.addAll(this.getScheduledEventsForward(jobs, MomentRange.range(this.now.nextMinute(), inclusionRange.getEnd()), inclusionRange, eventsType));
            }
        }
        Collections.sort(events, new CalendarEventComparator());
        return events;
    }

    public List<ScheduledCalendarEvent> getScheduledEventsForward(List<? extends Job> jobs, MomentRange searchRange, MomentRange inclusionRange, CalendarView.CalendarViewEventsType eventsType) {
        return this.getScheduledEvents(jobs, new ForwardScheduledEventCollector(searchRange, inclusionRange), eventsType);
    }

    public List<ScheduledCalendarEvent> getScheduledEventsBackward(List<? extends Job> jobs, MomentRange searchRange, MomentRange inclusionRange, CalendarView.CalendarViewEventsType eventsType) {
        return this.getScheduledEvents(jobs, new BackwardScheduledEventCollector(searchRange, inclusionRange), eventsType);
    }

    public List<ScheduledCalendarEvent> getScheduledEvents(List<? extends Job> jobs, ScheduledEventCollector collector, CalendarView.CalendarViewEventsType eventsType) {
        for (Job job : jobs) {
            if (!job.isBuildable()) continue;
            long estimatedDuration = job.getEstimatedDuration();
            List<CronWrapper<?>> cronTabs = this.cronJobService.getCronTabs(job, eventsType);
            for (CronWrapper<?> cronTab : cronTabs) {
                collector.collectEvents(job, cronTab, estimatedDuration);
            }
        }
        return collector.getEvents();
    }

    public List<StartedCalendarEvent> getFinishedEvents(List<? extends Job> jobs, MomentRange range, CalendarView.CalendarViewEventsType eventsType) {
        return this.getStartedEvents(jobs, range, CalendarEventState.FINISHED, eventsType);
    }

    public List<StartedCalendarEvent> getRunningEvents(List<? extends Job> jobs, MomentRange range, CalendarView.CalendarViewEventsType eventsType) {
        return this.getStartedEvents(jobs, range, CalendarEventState.RUNNING, eventsType);
    }

    public List<StartedCalendarEvent> getStartedEvents(List<? extends Job> jobs, MomentRange range, CalendarEventState state, CalendarView.CalendarViewEventsType eventsType) {
        if (state == CalendarEventState.SCHEDULED) {
            throw new IllegalArgumentException("State for started events cannot be " + String.valueOf((Object)CalendarEventState.SCHEDULED));
        }
        ArrayList<StartedCalendarEvent> events = new ArrayList<StartedCalendarEvent>();
        if (eventsType != CalendarView.CalendarViewEventsType.POLLINGS) {
            for (Job job : jobs) {
                if (state == CalendarEventState.RUNNING && !job.isBuilding()) continue;
                RunList builds = job.getBuilds();
                for (Run build : builds) {
                    StartedCalendarEvent event;
                    if (state == CalendarEventState.RUNNING && !build.isBuilding() || state == CalendarEventState.FINISHED && build.isBuilding() || !(event = this.calendarEventFactory.createStartedEvent(job, build)).isInRange(range)) continue;
                    events.add(event);
                }
            }
        }
        return events;
    }

    public List<StartedCalendarEvent> getLastEvents(CalendarEvent event, int numberOfEvents) {
        ArrayList<StartedCalendarEvent> lastEvents = new ArrayList<StartedCalendarEvent>();
        Job job = event.getJob();
        List lastBuilds = job.getLastBuildsOverThreshold(numberOfEvents, Result.ABORTED);
        for (Run lastBuild : lastBuilds) {
            StartedCalendarEvent lastEvent = this.calendarEventFactory.createStartedEvent(job, lastBuild);
            lastEvents.add(lastEvent);
        }
        return lastEvents;
    }

    public StartedCalendarEvent getPreviousEvent(StartedCalendarEvent event) {
        Run previousBuild;
        if (event.getBuild() != null && (previousBuild = event.getBuild().getPreviousBuild()) != null) {
            return this.calendarEventFactory.createStartedEvent(event.getJob(), previousBuild);
        }
        return null;
    }

    public StartedCalendarEvent getNextEvent(StartedCalendarEvent event) {
        Run nextBuild;
        if (event.getBuild() != null && (nextBuild = event.getBuild().getNextBuild()) != null) {
            return this.calendarEventFactory.createStartedEvent(event.getJob(), nextBuild);
        }
        return null;
    }

    public ScheduledCalendarEvent getNextScheduledEvent(CalendarEvent event, CalendarView.CalendarViewEventsType eventsType) {
        Job job = event.getJob();
        Calendar nextStart = this.cronJobService.getNextStart(job, eventsType);
        if (nextStart != null) {
            long estimatedDuration = job.getEstimatedDuration();
            return this.calendarEventFactory.createScheduledEvent(job, nextStart, estimatedDuration);
        }
        return null;
    }

    private class ForwardScheduledEventCollector
    extends ScheduledEventCollector {
        public ForwardScheduledEventCollector(MomentRange searchRange, MomentRange inclusionRange) {
            super(searchRange, inclusionRange);
        }

        @Override
        protected Calendar nextRun(CronWrapper<?> cronTab, long timeInMillis) {
            return cronTab.ceil(timeInMillis);
        }

        @Override
        protected long searchStart() {
            return this.searchRange.getStart().getTimeInMillis();
        }

        @Override
        protected int searchOffset() {
            return 60000;
        }
    }

    private abstract class ScheduledEventCollector {
        private final transient List<ScheduledCalendarEvent> events = new ArrayList<ScheduledCalendarEvent>();
        protected final transient MomentRange searchRange;
        private final transient MomentRange inclusionRange;

        public ScheduledEventCollector(MomentRange searchRange, MomentRange inclusionRange) {
            this.searchRange = searchRange;
            this.inclusionRange = inclusionRange;
        }

        public void collectEvents(Job job, CronWrapper<?> cronTab, long estimatedDuration) {
            Calendar next;
            long timeInMillis = this.searchStart();
            while ((next = this.nextRun(cronTab, timeInMillis)) != null && !this.searchRange.getStart().isAfter(next) && !this.searchRange.getEnd().isBefore(next)) {
                next.set(13, 0);
                next.set(14, 0);
                ScheduledCalendarEvent event = CalendarEventService.this.calendarEventFactory.createScheduledEvent(job, next, estimatedDuration);
                if (!event.isInRange(this.inclusionRange)) break;
                this.events.add(event);
                timeInMillis = next.getTimeInMillis() + (long)this.searchOffset();
            }
        }

        protected abstract Calendar nextRun(CronWrapper<?> var1, long var2);

        protected abstract long searchStart();

        protected abstract int searchOffset();

        public List<ScheduledCalendarEvent> getEvents() {
            return this.events;
        }
    }

    private class BackwardScheduledEventCollector
    extends ScheduledEventCollector {
        public BackwardScheduledEventCollector(MomentRange searchRange, MomentRange inclusionRange) {
            super(searchRange, inclusionRange);
        }

        @Override
        protected Calendar nextRun(CronWrapper<?> cronTab, long timeInMillis) {
            return cronTab.floor(timeInMillis);
        }

        @Override
        protected long searchStart() {
            return this.searchRange.getEnd().getTimeInMillis();
        }

        @Override
        protected int searchOffset() {
            return -60000;
        }
    }
}

