/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.view.calendar.time;

import io.jenkins.plugins.view.calendar.time.Moment;
import java.util.Calendar;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class MomentRange {
    private final Moment start;
    private final Moment end;

    public MomentRange(Calendar start, Calendar end) {
        this(new Moment(start), new Moment(end));
    }

    public MomentRange(Moment start, Moment end) {
        if (!MomentRange.isValidRange(start, end)) {
            throw new IllegalArgumentException("start has to be before end: " + String.valueOf(start) + " < " + String.valueOf(end));
        }
        this.start = start;
        this.end = end;
    }

    public long duration() {
        return MomentRange.duration(this.start, this.end);
    }

    public static long duration(Moment m1, Moment m2) {
        return m2.getTimeInMillis() - m1.getTimeInMillis();
    }

    public Moment getStart() {
        return this.start;
    }

    public Moment getEnd() {
        return this.end;
    }

    public static MomentRange range(Calendar start, Calendar end) {
        return new MomentRange(start, end);
    }

    public static MomentRange range(Moment start, Moment end) {
        return new MomentRange(start, end);
    }

    public static boolean isValidRange(Moment m1, Moment m2) {
        return m1.isBefore(m2);
    }

    public static boolean isValidRange(Calendar c1, Calendar c2) {
        return c1.before(c2);
    }

    public String toString() {
        return String.valueOf(this.start) + " - " + String.valueOf(this.end);
    }
}

