/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.view.calendar.time;

import io.jenkins.plugins.view.calendar.util.DateUtil;
import java.util.Calendar;
import java.util.Date;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class Moment
implements Comparable<Object> {
    private final Calendar calendar;

    public Moment() {
        this(Calendar.getInstance());
    }

    public Moment(long timeInMillis) {
        this.calendar = Calendar.getInstance();
        this.calendar.setTimeInMillis(timeInMillis);
    }

    public Moment(Calendar cal) {
        this.calendar = (Calendar)cal.clone();
    }

    public Moment nextMinute() {
        Calendar nextMinute = (Calendar)this.calendar.clone();
        nextMinute.set(13, 0);
        nextMinute.set(14, 0);
        nextMinute.add(12, 1);
        return new Moment(nextMinute);
    }

    public Moment previousMinute() {
        Calendar previousMinute = (Calendar)this.calendar.clone();
        previousMinute.set(13, 0);
        previousMinute.set(14, 0);
        previousMinute.add(12, -1);
        return new Moment(previousMinute);
    }

    public Date getTime() {
        return this.calendar.getTime();
    }

    public int hashCode() {
        return this.calendar.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof Moment && this.calendar.equals(((Moment)o).calendar);
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof Moment) {
            return this.calendar.compareTo(((Moment)o).calendar);
        }
        throw new IllegalArgumentException("Can't compare object of type " + o.getClass().getCanonicalName());
    }

    public boolean isBefore(Moment m) {
        return this.isBefore(m.calendar);
    }

    public boolean isBefore(Calendar c) {
        return this.calendar.compareTo(c) < 0;
    }

    public boolean isSame(Moment m) {
        return this.isSame(m.calendar);
    }

    public boolean isSame(Calendar c) {
        return this.calendar.compareTo(c) == 0;
    }

    public boolean isAfter(Moment m) {
        return this.isAfter(m.calendar);
    }

    public boolean isAfter(Calendar c) {
        return this.calendar.compareTo(c) > 0;
    }

    public long getTimeInMillis() {
        return this.calendar.getTimeInMillis();
    }

    public String toString() {
        return DateUtil.formatDateTime(this.calendar.getTime());
    }
}

